/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonException;
import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.filter.FavoriteStatusFilter;
import com.dracoon.sdk.filter.Filters;
import com.dracoon.sdk.filter.GetNodesFilters;
import com.dracoon.sdk.filter.NodeParentPathFilter;
import com.dracoon.sdk.filter.SearchNodesFilters;
import com.dracoon.sdk.internal.CryptoVersionConverter;
import com.dracoon.sdk.internal.DownloadStream;
import com.dracoon.sdk.internal.DownloadThread;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonRequestHandler;
import com.dracoon.sdk.internal.HttpStatus;
import com.dracoon.sdk.internal.ThreadHelper;
import com.dracoon.sdk.internal.UploadStream;
import com.dracoon.sdk.internal.UploadThread;
import com.dracoon.sdk.internal.mapper.FileMapper;
import com.dracoon.sdk.internal.mapper.FolderMapper;
import com.dracoon.sdk.internal.mapper.NodeMapper;
import com.dracoon.sdk.internal.mapper.RoomMapper;
import com.dracoon.sdk.internal.model.ApiCopyNodesRequest;
import com.dracoon.sdk.internal.model.ApiCreateFolderRequest;
import com.dracoon.sdk.internal.model.ApiCreateNodeCommentRequest;
import com.dracoon.sdk.internal.model.ApiCreateRoomRequest;
import com.dracoon.sdk.internal.model.ApiDeleteNodesRequest;
import com.dracoon.sdk.internal.model.ApiGetNodesVirusProtectionInfoRequest;
import com.dracoon.sdk.internal.model.ApiMoveNodesRequest;
import com.dracoon.sdk.internal.model.ApiNode;
import com.dracoon.sdk.internal.model.ApiNodeComment;
import com.dracoon.sdk.internal.model.ApiNodeCommentList;
import com.dracoon.sdk.internal.model.ApiNodeList;
import com.dracoon.sdk.internal.model.ApiNodeVirusProtectionInfo;
import com.dracoon.sdk.internal.model.ApiUpdateFileRequest;
import com.dracoon.sdk.internal.model.ApiUpdateFolderRequest;
import com.dracoon.sdk.internal.model.ApiUpdateNodeCommentRequest;
import com.dracoon.sdk.internal.model.ApiUpdateRoomConfigRequest;
import com.dracoon.sdk.internal.model.ApiUpdateRoomRequest;
import com.dracoon.sdk.internal.util.StreamUtils;
import com.dracoon.sdk.internal.validator.BaseValidator;
import com.dracoon.sdk.internal.validator.FileValidator;
import com.dracoon.sdk.internal.validator.FolderValidator;
import com.dracoon.sdk.internal.validator.NodeValidator;
import com.dracoon.sdk.internal.validator.RoomValidator;
import com.dracoon.sdk.model.CopyNodesRequest;
import com.dracoon.sdk.model.CreateFolderRequest;
import com.dracoon.sdk.model.CreateNodeCommentRequest;
import com.dracoon.sdk.model.CreateRoomRequest;
import com.dracoon.sdk.model.DeleteNodesRequest;
import com.dracoon.sdk.model.FileDownloadCallback;
import com.dracoon.sdk.model.FileDownloadStream;
import com.dracoon.sdk.model.FileUploadCallback;
import com.dracoon.sdk.model.FileUploadRequest;
import com.dracoon.sdk.model.FileUploadStream;
import com.dracoon.sdk.model.FileVirusScanInfo;
import com.dracoon.sdk.model.FileVirusScanInfoList;
import com.dracoon.sdk.model.GetFilesVirusScanInfoRequest;
import com.dracoon.sdk.model.MoveNodesRequest;
import com.dracoon.sdk.model.Node;
import com.dracoon.sdk.model.NodeComment;
import com.dracoon.sdk.model.NodeCommentList;
import com.dracoon.sdk.model.NodeList;
import com.dracoon.sdk.model.UpdateFileRequest;
import com.dracoon.sdk.model.UpdateFolderRequest;
import com.dracoon.sdk.model.UpdateNodeCommentRequest;
import com.dracoon.sdk.model.UpdateRoomConfigRequest;
import com.dracoon.sdk.model.UpdateRoomRequest;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

class DracoonNodesImpl
extends DracoonRequestHandler
implements DracoonClient.Nodes {
    private static final String LOG_TAG = DracoonNodesImpl.class.getSimpleName();
    private static final String MEDIA_URL_TEMPLATE = "%s/mediaserver/image/%s/%dx%d";
    private final Map<String, UploadThread> mUploads = new HashMap<String, UploadThread>();
    private final Map<String, DownloadThread> mDownloads = new HashMap<String, DownloadThread>();

    DracoonNodesImpl(DracoonClientImpl client) {
        super(client);
    }

    UploadThread getUploadThread(String id) {
        return this.mUploads.get(id);
    }

    void putUploadThread(String id, UploadThread uploadThread) {
        this.mUploads.put(id, uploadThread);
    }

    DownloadThread getDownloadThread(String id) {
        return this.mDownloads.get(id);
    }

    void putDownloadThread(String id, DownloadThread downloadThread) {
        this.mDownloads.put(id, downloadThread);
    }

    @Override
    public NodeList getNodes(long parentNodeId) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, null, null, null);
    }

    @Override
    public NodeList getNodes(long parentNodeId, GetNodesFilters filters) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, filters, null, null);
    }

    @Override
    public NodeList getNodes(long parentNodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, null, offset, limit);
    }

    @Override
    public NodeList getNodes(long parentNodeId, GetNodesFilters filters, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, filters, offset, limit);
    }

    private NodeList getNodesInternally(long parentNodeId, Filters filters, Long offset, Long limit) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateParentNodeId(parentNodeId);
        BaseValidator.validateRange(offset, limit, true);
        String filter = filters != null ? filters.toString() : null;
        Call<ApiNodeList> call = this.mService.getNodes(parentNodeId, 0, filter, null, offset, limit);
        Response<ApiNodeList> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesQueryError(response);
            String errorText = String.format("Query of child nodes of node '%d' failed with '%s'!", parentNodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeList data = (ApiNodeList)response.body();
        return NodeMapper.fromApiNodeList(data);
    }

    @Override
    public Node getNode(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<ApiNode> call = this.mService.getNode(nodeId);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesQueryError(response);
            String errorText = String.format("Query of node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node getNode(String nodePath) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodePath(nodePath);
        int slashPos = nodePath.lastIndexOf(47);
        String path = nodePath.substring(0, slashPos + 1);
        String name = nodePath.substring(slashPos + 1, nodePath.length());
        NodeParentPathFilter pathFilter = new NodeParentPathFilter.Builder().eq(path).build();
        SearchNodesFilters filters = new SearchNodesFilters();
        filters.addNodeParentPathFilter(pathFilter);
        NodeList nodeList = this.searchNodes(0L, name, filters);
        if (nodeList.getItems().isEmpty()) {
            DracoonApiCode errorCode = DracoonApiCode.SERVER_NODE_NOT_FOUND;
            String errorText = String.format("Query of node '%s' failed with '%s'!", nodePath, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return nodeList.getItems().get(0);
    }

    public boolean isNodeEncrypted(long nodeId) throws DracoonNetIOException, DracoonApiException {
        Node node = this.getNode(nodeId);
        return node.isEncrypted();
    }

    @Override
    public Node createRoom(CreateRoomRequest request) throws DracoonNetIOException, DracoonApiException {
        RoomValidator.validateCreateRequest(request);
        ApiCreateRoomRequest apiRequest = RoomMapper.toApiCreateRoomRequest(request);
        Call<ApiNode> call = this.mService.createRoom(apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseRoomCreateError(response);
            String errorText = String.format("Creation of room '%s' failed with '%s'!", request.getName(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node updateRoom(UpdateRoomRequest request) throws DracoonNetIOException, DracoonApiException {
        RoomValidator.validateUpdateRequest(request);
        ApiUpdateRoomRequest apiRequest = RoomMapper.toApiUpdateRoomRequest(request);
        Call<ApiNode> call = this.mService.updateRoom(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseRoomUpdateError(response);
            String errorText = String.format("Update of room '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node updateRoomConfig(UpdateRoomConfigRequest request) throws DracoonNetIOException, DracoonApiException {
        RoomValidator.validateUpdateConfigRequest(request);
        ApiUpdateRoomConfigRequest apiRequest = RoomMapper.toApiUpdateRoomConfigRequest(request);
        Call<ApiNode> call = this.mService.updateRoomConfig(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseRoomUpdateError(response);
            String errorText = String.format("Update config of room '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node createFolder(CreateFolderRequest request) throws DracoonNetIOException, DracoonApiException {
        FolderValidator.validateCreateRequest(request);
        ApiCreateFolderRequest apiRequest = FolderMapper.toApiCreateFolderRequest(request);
        Call<ApiNode> call = this.mService.createFolder(apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFolderCreateError(response);
            String errorText = String.format("Creation of folder '%s' failed with '%s'!", request.getName(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node updateFolder(UpdateFolderRequest request) throws DracoonNetIOException, DracoonApiException {
        FolderValidator.validateUpdateRequest(request);
        ApiUpdateFolderRequest apiRequest = FolderMapper.toApiUpdateFolderRequest(request);
        Call<ApiNode> call = this.mService.updateFolder(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFolderUpdateError(response);
            String errorText = String.format("Update of folder '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node updateFile(UpdateFileRequest request) throws DracoonNetIOException, DracoonApiException {
        FileValidator.validateUpdateRequest(request);
        ApiUpdateFileRequest apiRequest = FileMapper.toApiUpdateFileRequest(request);
        Call<ApiNode> call = this.mService.updateFile(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFileUpdateError(response);
            String errorText = String.format("Update of file '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public void deleteNodes(DeleteNodesRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateDeleteRequest(request);
        ApiDeleteNodesRequest apiRequest = NodeMapper.toApiDeleteNodesRequest(request);
        Call<Void> call = this.mService.deleteNodes(apiRequest);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesDeleteError(response);
            String errorText = String.format("Deletion of nodes %s failed with '%s'!", request.getIds(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public void deleteNode(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mService.deleteNode(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesDeleteError(response);
            String errorText = String.format("Deletion of node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public Node copyNodes(CopyNodesRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateCopyRequest(request);
        ApiCopyNodesRequest apiRequest = NodeMapper.toApiCopyNodesRequest(request);
        Call<ApiNode> call = this.mService.copyNodes(request.getTargetNodeId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesCopyError(response);
            String errorText = String.format("Copy to node '%d' failed with '%s'!", request.getTargetNodeId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node moveNodes(MoveNodesRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateMoveRequest(request);
        ApiMoveNodesRequest apiRequest = NodeMapper.toApiMoveNodesRequest(request);
        Call<ApiNode> call = this.mService.moveNodes(request.getTargetNodeId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesMoveError(response);
            String errorText = String.format("Move to node '%d' failed with '%s'!", request.getTargetNodeId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @Override
    public Node uploadFile(String id, FileUploadRequest request, File file, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, file);
        InputStream is = this.mClient.getFileStreamHelper().getFileInputStream(file);
        long length = file.length();
        return this.uploadFileInternally(id, request, is, length, true, callback);
    }

    @Override
    public Node uploadFile(String id, FileUploadRequest request, InputStream is, long length, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, is);
        return this.uploadFileInternally(id, request, is, length, false, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node uploadFileInternally(String id, FileUploadRequest request, InputStream is, long length, boolean close, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        Node node;
        UserPublicKey userPublicKey = this.getUploadUserPublicKey(request.getParentId());
        PlainFileKey plainFileKey = this.createUploadFileKey(userPublicKey);
        UploadThread uploadThread = UploadThread.create(this.mClient, id, request, length, userPublicKey, plainFileKey, is);
        uploadThread.addCallback(callback);
        try {
            node = uploadThread.runSync();
        }
        finally {
            DracoonNodesImpl.closeStream(is, close);
        }
        return node;
    }

    @Override
    public void startUploadFileAsync(String id, FileUploadRequest request, File file, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, file);
        InputStream is = this.mClient.getFileStreamHelper().getFileInputStream(file);
        long length = file.length();
        this.startUploadFileAsyncInternally(id, request, is, length, true, callback);
    }

    @Override
    public void startUploadFileAsync(String id, FileUploadRequest request, InputStream is, long length, FileUploadCallback callback) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, is);
        this.startUploadFileAsyncInternally(id, request, is, length, false, callback);
    }

    private void startUploadFileAsyncInternally(String id, FileUploadRequest request, final InputStream is, long length, final boolean close, FileUploadCallback callback) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        UserPublicKey userPublicKey = this.getUploadUserPublicKey(request.getParentId());
        PlainFileKey plainFileKey = this.createUploadFileKey(userPublicKey);
        FileUploadCallback internalCallback = new FileUploadCallback(){

            @Override
            public void onStarted(String id) {
            }

            @Override
            public void onRunning(String id, long bytesSend, long bytesTotal) {
            }

            @Override
            public void onFinished(String id, Node node) {
                DracoonNodesImpl.closeStream(is, close);
                DracoonNodesImpl.this.mUploads.remove(id);
            }

            @Override
            public void onCanceled(String id) {
                DracoonNodesImpl.closeStream(is, close);
                DracoonNodesImpl.this.mUploads.remove(id);
            }

            @Override
            public void onFailed(String id, DracoonException e) {
                DracoonNodesImpl.closeStream(is, close);
                DracoonNodesImpl.this.mUploads.remove(id);
            }
        };
        UploadThread uploadThread = UploadThread.create(this.mClient, id, request, length, userPublicKey, plainFileKey, is);
        uploadThread.addCallback(callback);
        uploadThread.addCallback(internalCallback);
        this.mUploads.put(id, uploadThread);
        uploadThread.start();
    }

    @Override
    public void cancelUploadFileAsync(String id) {
        UploadThread uploadThread = this.mUploads.get(id);
        if (uploadThread == null) {
            return;
        }
        ThreadHelper threadHelper = this.mClient.getThreadHelper();
        if (threadHelper.isThreadAlive(uploadThread)) {
            threadHelper.interruptThread(uploadThread);
        }
        this.mUploads.remove(id);
    }

    @Override
    public FileUploadStream createFileUploadStream(String id, FileUploadRequest request, long length, FileUploadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        FileValidator.validateUploadRequest(request);
        UserPublicKey userPublicKey = this.getUploadUserPublicKey(request.getParentId());
        PlainFileKey plainFileKey = this.createUploadFileKey(userPublicKey);
        UploadStream uploadStream = UploadStream.create(this.mClient, id, request, length, userPublicKey, plainFileKey);
        if (callback != null) {
            uploadStream.addCallback(callback);
        }
        uploadStream.start();
        return uploadStream;
    }

    private UserPublicKey getUploadUserPublicKey(long parentNodeId) throws DracoonNetIOException, DracoonApiException {
        boolean isEncryptedUpload = this.isNodeEncrypted(parentNodeId);
        if (!isEncryptedUpload) {
            return null;
        }
        UserKeyPair userKeyPair = this.mClient.getAccountImpl().getPreferredUserKeyPair();
        return userKeyPair.getUserPublicKey();
    }

    private PlainFileKey createUploadFileKey(UserPublicKey userPublicKey) throws DracoonCryptoException {
        if (userPublicKey == null) {
            return null;
        }
        PlainFileKey.Version version = CryptoVersionConverter.determinePlainFileKeyVersion(userPublicKey.getVersion());
        return this.mClient.getCryptoWrapper().generateFileKey(version);
    }

    @Override
    public void downloadFile(String id, long nodeId, File file, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        FileValidator.validateDownloadRequest(id, file);
        OutputStream os = this.mClient.getFileStreamHelper().getFileOutputStream(file);
        this.downloadFileInternally(id, nodeId, os, true, callback);
    }

    @Override
    public void downloadFile(String id, long nodeId, OutputStream os, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        FileValidator.validateDownloadRequest(id, os);
        this.downloadFileInternally(id, nodeId, os, false, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFileInternally(String id, long nodeId, OutputStream os, boolean close, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        PlainFileKey plainFileKey = this.getDownloadFileKey(nodeId);
        DownloadThread downloadThread = DownloadThread.create(this.mClient, id, nodeId, plainFileKey, os);
        if (callback != null) {
            downloadThread.addCallback(callback);
        }
        try {
            downloadThread.runSync();
        }
        finally {
            DracoonNodesImpl.closeStream(os, close);
        }
    }

    @Override
    public void startDownloadFileAsync(String id, long nodeId, File file, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        FileValidator.validateDownloadRequest(id, file);
        OutputStream os = this.mClient.getFileStreamHelper().getFileOutputStream(file);
        this.startDownloadFileAsyncInternally(id, nodeId, os, true, callback);
    }

    @Override
    public void startDownloadFileAsync(String id, long nodeId, OutputStream os, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        FileValidator.validateDownloadRequest(id, os);
        this.startDownloadFileAsyncInternally(id, nodeId, os, false, callback);
    }

    private void startDownloadFileAsyncInternally(String id, long nodeId, final OutputStream os, final boolean close, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        PlainFileKey plainFileKey = this.getDownloadFileKey(nodeId);
        FileDownloadCallback stoppedCallback = new FileDownloadCallback(){

            @Override
            public void onStarted(String id) {
            }

            @Override
            public void onRunning(String id, long bytesSend, long bytesTotal) {
            }

            @Override
            public void onFinished(String id) {
                DracoonNodesImpl.closeStream(os, close);
                DracoonNodesImpl.this.mDownloads.remove(id);
            }

            @Override
            public void onCanceled(String id) {
                DracoonNodesImpl.closeStream(os, close);
                DracoonNodesImpl.this.mDownloads.remove(id);
            }

            @Override
            public void onFailed(String id, DracoonException e) {
                DracoonNodesImpl.closeStream(os, close);
                DracoonNodesImpl.this.mDownloads.remove(id);
            }
        };
        DownloadThread downloadThread = DownloadThread.create(this.mClient, id, nodeId, plainFileKey, os);
        downloadThread.addCallback(stoppedCallback);
        if (callback != null) {
            downloadThread.addCallback(callback);
        }
        this.mDownloads.put(id, downloadThread);
        downloadThread.start();
    }

    @Override
    public void cancelDownloadFileAsync(String id) {
        DownloadThread downloadThread = this.mDownloads.get(id);
        if (downloadThread == null) {
            return;
        }
        ThreadHelper threadHelper = this.mClient.getThreadHelper();
        if (threadHelper.isThreadAlive(downloadThread)) {
            threadHelper.interruptThread(downloadThread);
        }
        this.mDownloads.remove(id);
    }

    @Override
    public FileDownloadStream createFileDownloadStream(String id, long nodeId, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        PlainFileKey plainFileKey = this.getDownloadFileKey(nodeId);
        DownloadStream downloadStream = DownloadStream.create(this.mClient, id, nodeId, plainFileKey);
        if (callback != null) {
            downloadStream.addCallback(callback);
        }
        downloadStream.start();
        return downloadStream;
    }

    private PlainFileKey getDownloadFileKey(long nodeId) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        return this.mClient.getFileKeyFetcher().getPlainFileKey(nodeId);
    }

    @Override
    public NodeList searchNodes(long parentNodeId, String searchString) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, null, null, null);
    }

    @Override
    public NodeList searchNodes(long parentNodeId, String searchString, SearchNodesFilters filters) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, filters, null, null);
    }

    @Override
    public NodeList searchNodes(long parentNodeId, String searchString, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, null, offset, limit);
    }

    @Override
    public NodeList searchNodes(long parentNodeId, String searchString, SearchNodesFilters filters, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, filters, offset, limit);
    }

    private NodeList searchNodesInternally(long parentNodeId, String searchString, SearchNodesFilters filters, Long offset, Long limit) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateSearchRequest(parentNodeId, searchString);
        BaseValidator.validateRange(offset, limit, true);
        String filter = filters != null ? filters.toString() : null;
        Call<ApiNodeList> call = this.mService.searchNodes(searchString, parentNodeId, -1, filter, null, offset, limit);
        Response<ApiNodeList> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesQueryError(response);
            String errorText = String.format("Node search '%s' in node '%d' failed with '%s'!", searchString, parentNodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeList data = (ApiNodeList)response.body();
        return NodeMapper.fromApiNodeList(data);
    }

    @Override
    public boolean generateMissingFileKeys(int limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        return this.generateMissingFileKeysInternally(null, limit);
    }

    @Override
    public boolean generateMissingFileKeys(long nodeId, int limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        NodeValidator.validateNodeId(nodeId);
        return this.generateMissingFileKeysInternally(nodeId, limit);
    }

    private boolean generateMissingFileKeysInternally(Long nodeId, Integer limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        return this.mClient.getFileKeyGenerator().generateMissingFileKeys(nodeId, limit);
    }

    @Override
    public void markFavorite(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mService.markFavorite(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFavoriteMarkError(response);
            String errorText = String.format("Mark node %s as favorite failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            if (!errorCode.isValidationError()) {
                throw new DracoonApiException(errorCode);
            }
        }
    }

    @Override
    public void unmarkFavorite(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mService.unmarkFavorite(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            if (response.code() == HttpStatus.BAD_REQUEST.getNumber()) {
                return;
            }
            DracoonApiCode errorCode = this.mErrorParser.parseFavoriteMarkError(response);
            String errorText = String.format("Unmark node %s as favorite failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public NodeList getFavorites() throws DracoonNetIOException, DracoonApiException {
        SearchNodesFilters filters = new SearchNodesFilters();
        filters.addFavoriteStatusFilter(new FavoriteStatusFilter.Builder().eq(true).build());
        return this.searchNodes(0L, "*", filters);
    }

    @Override
    public NodeList getFavorites(long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        SearchNodesFilters filters = new SearchNodesFilters();
        filters.addFavoriteStatusFilter(new FavoriteStatusFilter.Builder().eq(true).build());
        return this.searchNodes(0L, "*", filters, offset, limit);
    }

    @Override
    public NodeCommentList getNodeComments(long nodeId) throws DracoonNetIOException, DracoonApiException {
        return this.getNodeCommentsInternally(nodeId, null, null);
    }

    @Override
    public NodeCommentList getNodeComments(long nodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.getNodeCommentsInternally(nodeId, offset, limit);
    }

    private NodeCommentList getNodeCommentsInternally(long nodeId, Long offset, Long limit) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        BaseValidator.validateRange(offset, limit, true);
        Call<ApiNodeCommentList> call = this.mService.getNodeComments(nodeId, offset, limit);
        Response<ApiNodeCommentList> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentsQueryError(response);
            String errorText = String.format("Query of node comments for node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeCommentList data = (ApiNodeCommentList)response.body();
        return NodeMapper.fromApiNodeCommentList(data);
    }

    @Override
    public NodeComment createNodeComment(CreateNodeCommentRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateCreateCommentRequest(request);
        ApiCreateNodeCommentRequest apiRequest = NodeMapper.toApiCreateNodeCommentRequest(request);
        Call<ApiNodeComment> call = this.mService.createNodeComment(request.getNodeId(), apiRequest);
        Response<ApiNodeComment> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentCreateError(response);
            String errorText = String.format("Creation of comment on node '%d' failed with '%s'!", request.getNodeId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeComment data = (ApiNodeComment)response.body();
        return NodeMapper.fromApiNodeComment(data);
    }

    @Override
    public NodeComment updateNodeComment(UpdateNodeCommentRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateUpdateCommentRequest(request);
        ApiUpdateNodeCommentRequest apiRequest = NodeMapper.toApiUpdateNodeCommentRequest(request);
        Call<ApiNodeComment> call = this.mService.updateNodeComment(request.getId(), apiRequest);
        Response<ApiNodeComment> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentUpdateError(response);
            String errorText = String.format("Update of comment '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeComment data = (ApiNodeComment)response.body();
        return NodeMapper.fromApiNodeComment(data);
    }

    @Override
    public void deleteNodeComment(long commentId) throws DracoonNetIOException, DracoonApiException {
        BaseValidator.validateCommentId(commentId);
        Call<Void> call = this.mService.deleteNodeComment(commentId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentDeleteError(response);
            String errorText = String.format("Deletion of comment '%d' failed with '%s'!", commentId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public FileVirusScanInfoList getFilesVirusScanInformation(GetFilesVirusScanInfoRequest request) throws DracoonNetIOException, DracoonApiException {
        this.mClient.checkApiVersionGreaterEqual("4.44.0");
        NodeValidator.validateGetVirusScanInfoRequest(request);
        return this.getFilesVirusScanInformationInternally(request.getIds());
    }

    @Override
    public FileVirusScanInfo getFileVirusScanInformation(long nodeId) throws DracoonNetIOException, DracoonApiException {
        this.mClient.checkApiVersionGreaterEqual("4.44.0");
        NodeValidator.validateNodeId(nodeId);
        FileVirusScanInfoList fileVirusScanInfoList = this.getFilesVirusScanInformationInternally(Collections.singletonList(nodeId));
        if (fileVirusScanInfoList == null) {
            return null;
        }
        return !fileVirusScanInfoList.getItems().isEmpty() ? fileVirusScanInfoList.getItems().get(0) : null;
    }

    private FileVirusScanInfoList getFilesVirusScanInformationInternally(List<Long> nodeIds) throws DracoonNetIOException, DracoonApiException {
        ApiGetNodesVirusProtectionInfoRequest request = new ApiGetNodesVirusProtectionInfoRequest();
        request.nodeIds = nodeIds;
        Call<List<ApiNodeVirusProtectionInfo>> call = this.mService.getNodesVirusProtectionInfo(request);
        Response<List<ApiNodeVirusProtectionInfo>> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesVirusProtectionInfoGetError(response);
            String errorText = String.format("Retrieval of virus scan info of nodes %s failed with '%s'!", nodeIds, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        List data = (List)response.body();
        return NodeMapper.fromApiNodeVirusProtectionInfos(data);
    }

    @Override
    public void deleteMaliciousFile(long nodeId) throws DracoonNetIOException, DracoonApiException {
        this.mClient.checkApiVersionGreaterEqual("4.44.0");
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mService.deleteMaliciousFile(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseMaliciousFileDeleteError(response);
            String errorText = String.format("Deletion of malicious file '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @Override
    public URL buildMediaUrl(String mediaToken, int width, int height) {
        NodeValidator.validateMediaUrlRequest(mediaToken, width, height);
        String url = String.format(MEDIA_URL_TEMPLATE, this.mClient.getServerUrl(), mediaToken, width, height);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    private static void closeStream(InputStream is, boolean close) {
        if (close) {
            StreamUtils.closeStream(is);
        }
    }

    private static void closeStream(OutputStream os, boolean close) {
        if (close) {
            StreamUtils.closeStream(os);
        }
    }
}

