/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonRequestHandler;
import com.dracoon.sdk.internal.model.ApiServerInfo;
import com.dracoon.sdk.internal.model.ApiServerTime;
import java.util.Date;
import retrofit2.Call;
import retrofit2.Response;

class DracoonServerImpl
extends DracoonRequestHandler
implements DracoonClient.Server {
    private static final String LOG_TAG = DracoonServerImpl.class.getSimpleName();

    DracoonServerImpl(DracoonClientImpl client) {
        super(client);
    }

    @Override
    public String getVersion() throws DracoonNetIOException, DracoonApiException {
        return this.getServerInfo().restApiVersion;
    }

    @Override
    public Boolean isDracoonCloud() throws DracoonNetIOException, DracoonApiException {
        return this.getServerInfo().isDracoonCloud;
    }

    private ApiServerInfo getServerInfo() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerInfo> call = this.mService.getServerInfo();
        Response<ApiServerInfo> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseServerInfoQueryError(response);
            String errorText = String.format("Query of server info failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return (ApiServerInfo)response.body();
    }

    @Override
    public Date getTime() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerTime> call = this.mService.getServerTime();
        Response<ApiServerTime> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of server time failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return ((ApiServerTime)response.body()).time;
    }

    @Override
    public DracoonClient.ServerSettings settings() {
        return this.mClient.getServerSettingsImpl();
    }

    @Override
    public DracoonClient.ServerPolicies policies() {
        return this.mClient.getServerPoliciesImpl();
    }
}

