/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonRequestHandler;
import com.dracoon.sdk.internal.mapper.ServerMapper;
import com.dracoon.sdk.internal.model.ApiServerClassificationPolicies;
import com.dracoon.sdk.internal.model.ApiServerPasswordPolicies;
import com.dracoon.sdk.model.ClassificationPolicies;
import com.dracoon.sdk.model.PasswordPolicies;
import retrofit2.Call;
import retrofit2.Response;

class DracoonServerPoliciesImpl
extends DracoonRequestHandler
implements DracoonClient.ServerPolicies {
    private static final String LOG_TAG = DracoonServerPoliciesImpl.class.getSimpleName();

    DracoonServerPoliciesImpl(DracoonClientImpl client) {
        super(client);
    }

    @Override
    public PasswordPolicies getEncryptionPasswordPolicies() throws DracoonNetIOException, DracoonApiException {
        ApiServerPasswordPolicies passwordPolicies = this.getPasswordPolicies();
        return ServerMapper.fromApiEncryptionPasswordPolicies(passwordPolicies.encryptionPasswordPolicies);
    }

    @Override
    public PasswordPolicies getSharesPasswordPolicies() throws DracoonNetIOException, DracoonApiException {
        ApiServerPasswordPolicies passwordPolicies = this.getPasswordPolicies();
        return ServerMapper.fromApiSharesPasswordPolicies(passwordPolicies.sharesPasswordPolicies);
    }

    private ApiServerPasswordPolicies getPasswordPolicies() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerPasswordPolicies> call = this.mService.getServerPasswordPolicies();
        Response<ApiServerPasswordPolicies> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of server password policies failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return (ApiServerPasswordPolicies)response.body();
    }

    @Override
    public ClassificationPolicies getClassificationPolicies() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerClassificationPolicies> call = this.mService.getServerClassificationPolicies();
        Response<ApiServerClassificationPolicies> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of server classification policies failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiServerClassificationPolicies data = (ApiServerClassificationPolicies)response.body();
        return ServerMapper.fromApiClassificationPolicies(data);
    }
}

