/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoCode;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.CryptoErrorParser;
import com.dracoon.sdk.internal.CryptoVersionConverter;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonErrorParser;
import com.dracoon.sdk.internal.DracoonService;
import com.dracoon.sdk.internal.HttpHelper;
import com.dracoon.sdk.internal.mapper.FileMapper;
import com.dracoon.sdk.internal.model.ApiFileKey;
import retrofit2.Call;
import retrofit2.Response;

class FileKeyFetcher {
    private static final String LOG_TAG = FileKeyFetcher.class.getSimpleName();
    private final DracoonClientImpl mClient;
    private final Log mLog;
    private final DracoonService mService;
    private final HttpHelper mHttpHelper;
    private final DracoonErrorParser mErrorParser;

    FileKeyFetcher(DracoonClientImpl client) {
        this.mClient = client;
        this.mLog = client.getLog();
        this.mService = client.getDracoonService();
        this.mHttpHelper = client.getHttpHelper();
        this.mErrorParser = client.getDracoonErrorParser();
    }

    public PlainFileKey getPlainFileKey(long nodeId) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        if (!this.mClient.getNodesImpl().isNodeEncrypted(nodeId)) {
            return null;
        }
        char[] userPrivateKeyPassword = this.mClient.getEncryptionPasswordOrAbort();
        EncryptedFileKey encFileKey = this.getFileKey(nodeId);
        UserKeyPair.Version userKeyPairVersion = CryptoVersionConverter.determineUserKeyPairVersion((EncryptedFileKey.Version)encFileKey.getVersion());
        UserKeyPair userKeyPair = this.mClient.getAccountImpl().getAndCheckUserKeyPair(userKeyPairVersion);
        return this.mClient.getCryptoWrapper().decryptFileKey(nodeId, encFileKey, userKeyPair.getUserPrivateKey(), userPrivateKeyPassword);
    }

    private EncryptedFileKey getFileKey(long nodeId) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        Call<ApiFileKey> call = this.mService.getFileKey(nodeId);
        Response<ApiFileKey> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFileKeyQueryError(response);
            String errorText = String.format("Query of file key for node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiFileKey data = (ApiFileKey)response.body();
        try {
            return FileMapper.fromApiFileKey(data);
        }
        catch (UnknownVersionException e) {
            String errorText = String.format("Query of file key for node '%d' failed! File key version is unknown!", nodeId);
            this.mLog.d(LOG_TAG, errorText);
            DracoonCryptoCode errorCode = CryptoErrorParser.parseCause((Exception)((Object)e));
            throw new DracoonCryptoException(errorCode, (Throwable)e);
        }
    }
}

