/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.CryptoVersionConverter;
import com.dracoon.sdk.internal.CryptoWrapper;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonErrorParser;
import com.dracoon.sdk.internal.DracoonService;
import com.dracoon.sdk.internal.HttpHelper;
import com.dracoon.sdk.internal.mapper.FileMapper;
import com.dracoon.sdk.internal.mapper.UserMapper;
import com.dracoon.sdk.internal.model.ApiFileIdFileKey;
import com.dracoon.sdk.internal.model.ApiFileKey;
import com.dracoon.sdk.internal.model.ApiMissingFileKeys;
import com.dracoon.sdk.internal.model.ApiSetFileKeysRequest;
import com.dracoon.sdk.internal.model.ApiUserIdFileId;
import com.dracoon.sdk.internal.model.ApiUserIdFileIdFileKey;
import com.dracoon.sdk.internal.model.ApiUserIdUserPublicKey;
import com.dracoon.sdk.internal.validator.BaseValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

class FileKeyGenerator {
    private static final String LOG_TAG = FileKeyGenerator.class.getSimpleName();
    private final DracoonClientImpl mClient;
    private final Log mLog;
    private final DracoonService mService;
    private final HttpHelper mHttpHelper;
    private final DracoonErrorParser mErrorParser;

    FileKeyGenerator(DracoonClientImpl client) {
        this.mClient = client;
        this.mLog = client.getLog();
        this.mService = client.getDracoonService();
        this.mHttpHelper = client.getHttpHelper();
        this.mErrorParser = client.getDracoonErrorParser();
    }

    public boolean generateMissingFileKeys(Long nodeId, Integer limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        BaseValidator.validateLimit(limit, false);
        List<UserKeyPair> userKeyPairs = this.mClient.getAccountImpl().getAndCheckUserKeyPairs();
        Map<UserKeyPair.Version, UserPrivateKey> userPrivateKeys = FileKeyGenerator.convertUserPrivateKeys(userKeyPairs);
        char[] userPrivateKeyPassword = this.mClient.getEncryptionPasswordOrAbort();
        boolean isFinished = false;
        long batchOffset = 0L;
        long batchMaxLimit = 10L;
        while (!isFinished) {
            long batchLimit = Math.min((long)limit.intValue() - batchOffset, batchMaxLimit);
            isFinished = this.generateMissingFileKeysBatch(userPrivateKeys, userPrivateKeyPassword, nodeId, batchOffset, batchLimit);
            if ((batchOffset += batchLimit) < (long)limit.intValue()) continue;
            break;
        }
        return isFinished;
    }

    private static Map<UserKeyPair.Version, UserPrivateKey> convertUserPrivateKeys(List<UserKeyPair> userKeyPairs) {
        HashMap<UserKeyPair.Version, UserPrivateKey> userPrivateKeys = new HashMap<UserKeyPair.Version, UserPrivateKey>();
        for (UserKeyPair userKeyPair : userKeyPairs) {
            UserPrivateKey userPrivateKey = userKeyPair.getUserPrivateKey();
            userPrivateKeys.put(userPrivateKey.getVersion(), userPrivateKey);
        }
        return userPrivateKeys;
    }

    private boolean generateMissingFileKeysBatch(Map<UserKeyPair.Version, UserPrivateKey> userPrivateKeys, char[] userPrivateKeyPassword, Long nodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        ApiMissingFileKeys apiMissingFileKeys = this.getMissingFileKeysBatch(nodeId, offset, limit);
        if (apiMissingFileKeys.items.isEmpty()) {
            return true;
        }
        List<ApiUserIdFileId> apiUserIdFileIds = apiMissingFileKeys.items;
        Map<Long, List<UserPublicKey>> usersPublicKeys = FileKeyGenerator.convertUserPublicKeys(apiMissingFileKeys.users);
        Map<Long, List<EncryptedFileKey>> encFilesKeys = FileKeyGenerator.convertFileKeys(apiMissingFileKeys.files);
        Map<Long, PlainFileKey> plainFileKeys = this.decryptFileKeys(encFilesKeys, userPrivateKeys, userPrivateKeyPassword);
        ArrayList<ApiUserIdFileIdFileKey> apiUserIdFileIdFileKeys = new ArrayList<ApiUserIdFileIdFileKey>();
        CryptoWrapper crypto = this.mClient.getCryptoWrapper();
        for (ApiUserIdFileId apiUserIdFileId : apiUserIdFileIds) {
            List<UserPublicKey> userPublicKeys = usersPublicKeys.get(apiUserIdFileId.userId);
            PlainFileKey plainFileKey = plainFileKeys.get(apiUserIdFileId.fileId);
            if (userPublicKeys == null || plainFileKey == null) continue;
            for (UserPublicKey userPublicKey : userPublicKeys) {
                EncryptedFileKey encFileKey = crypto.encryptFileKey(apiUserIdFileId.fileId, plainFileKey, userPublicKey);
                ApiFileKey apiFileKey = FileMapper.toApiFileKey(encFileKey);
                ApiUserIdFileIdFileKey apiUserIdFileIdFileKey = new ApiUserIdFileIdFileKey();
                apiUserIdFileIdFileKey.userId = apiUserIdFileId.userId;
                apiUserIdFileIdFileKey.fileId = apiUserIdFileId.fileId;
                apiUserIdFileIdFileKey.fileKey = apiFileKey;
                apiUserIdFileIdFileKeys.add(apiUserIdFileIdFileKey);
            }
        }
        this.setFileKeysBatch(apiUserIdFileIdFileKeys);
        return apiMissingFileKeys.range.total <= offset + limit;
    }

    private ApiMissingFileKeys getMissingFileKeysBatch(Long nodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        Call<ApiMissingFileKeys> call = this.mService.getMissingFileKeys(nodeId, offset, limit);
        Response<ApiMissingFileKeys> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseMissingFileKeysQueryError(response);
            String errorText = String.format("Query of missing file keys failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return (ApiMissingFileKeys)response.body();
    }

    private static Map<Long, List<UserPublicKey>> convertUserPublicKeys(List<ApiUserIdUserPublicKey> apiUserIdUserPublicKeys) {
        HashMap<Long, List<UserPublicKey>> usersPublicKeys = new HashMap<Long, List<UserPublicKey>>();
        for (ApiUserIdUserPublicKey apiUserIdUserPublicKey : apiUserIdUserPublicKeys) {
            try {
                UserPublicKey userPublicKey = UserMapper.fromApiUserPublicKey(apiUserIdUserPublicKey.publicKeyContainer);
                List userPublicKeys = (List)usersPublicKeys.get(apiUserIdUserPublicKey.id);
                if (userPublicKeys != null) {
                    userPublicKeys.add(userPublicKey);
                    continue;
                }
                usersPublicKeys.put(apiUserIdUserPublicKey.id, Collections.singletonList(userPublicKey));
            }
            catch (UnknownVersionException unknownVersionException) {}
        }
        return usersPublicKeys;
    }

    private static Map<Long, List<EncryptedFileKey>> convertFileKeys(List<ApiFileIdFileKey> apiFileIdFileKeys) {
        HashMap<Long, List<EncryptedFileKey>> encFilesKeys = new HashMap<Long, List<EncryptedFileKey>>();
        for (ApiFileIdFileKey apiFileIdFileKey : apiFileIdFileKeys) {
            try {
                EncryptedFileKey encFileKey = FileMapper.fromApiFileKey(apiFileIdFileKey.fileKeyContainer);
                List encFileKeys = (List)encFilesKeys.get(apiFileIdFileKey.id);
                if (encFileKeys != null) {
                    encFileKeys.add(encFileKey);
                    continue;
                }
                encFilesKeys.put(apiFileIdFileKey.id, Collections.singletonList(encFileKey));
            }
            catch (UnknownVersionException unknownVersionException) {}
        }
        return encFilesKeys;
    }

    private Map<Long, PlainFileKey> decryptFileKeys(Map<Long, List<EncryptedFileKey>> encFilesKeys, Map<UserKeyPair.Version, UserPrivateKey> userPrivateKeys, char[] userPrivateKeyPassword) throws DracoonCryptoException {
        CryptoWrapper crypto = this.mClient.getCryptoWrapper();
        HashMap<Long, PlainFileKey> plainFileKeys = new HashMap<Long, PlainFileKey>();
        block0: for (Map.Entry<Long, List<EncryptedFileKey>> encFileKeys : encFilesKeys.entrySet()) {
            for (EncryptedFileKey encFileKey : encFileKeys.getValue()) {
                UserKeyPair.Version userKeyPairVersion = CryptoVersionConverter.determineUserKeyPairVersion((EncryptedFileKey.Version)encFileKey.getVersion());
                UserPrivateKey userPrivateKey = userPrivateKeys.get(userKeyPairVersion);
                if (userPrivateKey == null) continue;
                PlainFileKey plainFileKey = crypto.decryptFileKey(encFileKeys.getKey(), encFileKey, userPrivateKey, userPrivateKeyPassword);
                plainFileKeys.put(encFileKeys.getKey(), plainFileKey);
                continue block0;
            }
        }
        return plainFileKeys;
    }

    private void setFileKeysBatch(List<ApiUserIdFileIdFileKey> apiUserIdFileIdFileKeys) throws DracoonNetIOException, DracoonApiException {
        ApiSetFileKeysRequest request = new ApiSetFileKeysRequest();
        request.items = apiUserIdFileIdFileKeys;
        Call<Void> call = this.mService.setFileKeys(request);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFileKeysSetError(response);
            String errorText = String.format("Setting missing file keys failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }
}

