/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.FileEncryptionCipher;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.model.EncryptedDataContainer;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainDataContainer;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoCode;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonException;
import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.CryptoErrorParser;
import com.dracoon.sdk.internal.CryptoWrapper;
import com.dracoon.sdk.internal.DracoonClientImpl;
import com.dracoon.sdk.internal.DracoonErrorParser;
import com.dracoon.sdk.internal.DracoonService;
import com.dracoon.sdk.internal.HttpHelper;
import com.dracoon.sdk.internal.mapper.FileMapper;
import com.dracoon.sdk.internal.mapper.NodeMapper;
import com.dracoon.sdk.internal.model.ApiCompleteFileUploadRequest;
import com.dracoon.sdk.internal.model.ApiCompleteS3FileUploadRequest;
import com.dracoon.sdk.internal.model.ApiCreateFileUploadRequest;
import com.dracoon.sdk.internal.model.ApiExpiration;
import com.dracoon.sdk.internal.model.ApiFileUpload;
import com.dracoon.sdk.internal.model.ApiGetS3FileUploadUrlsRequest;
import com.dracoon.sdk.internal.model.ApiNode;
import com.dracoon.sdk.internal.model.ApiS3FileUploadPart;
import com.dracoon.sdk.internal.model.ApiS3FileUploadStatus;
import com.dracoon.sdk.internal.model.ApiS3FileUploadUrlList;
import com.dracoon.sdk.internal.model.ApiServerGeneralSettings;
import com.dracoon.sdk.model.FileUploadCallback;
import com.dracoon.sdk.model.FileUploadRequest;
import com.dracoon.sdk.model.FileUploadStream;
import com.dracoon.sdk.model.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class UploadStream
extends FileUploadStream {
    private static final String LOG_TAG = UploadStream.class.getSimpleName();
    private static final int BLOCK_SIZE = 2048;
    private static final long PROGRESS_UPDATE_INTERVAL = 100L;
    private static final String S3_ETAG_HEADER = "ETag";
    private static final long S3_MIN_COMPLETE_WAIT_TIME = 500L;
    private static final long S3_MAX_COMPLETE_WAIT_TIME = 5000L;
    private static final String S3_UPLOAD_STATUS_TRANSFER = "transfer";
    private static final String S3_UPLOAD_STATUS_FINISHING = "finishing";
    private static final String S3_UPLOAD_STATUS_DONE = "done";
    private static final String S3_UPLOAD_STATUS_ERROR = "error";
    private final DracoonClientImpl mClient;
    private final Log mLog;
    private final DracoonService mService;
    private final OkHttpClient mHttpClient;
    private final HttpHelper mHttpHelper;
    private final DracoonErrorParser mErrorParser;
    private final CryptoWrapper mCrypto;
    private final String mId;
    private final FileUploadRequest mFileUploadRequest;
    private final UserPublicKey mUserPublicKey;
    private final PlainFileKey mFileKey;
    private FileEncryptionCipher mEncryptionCipher;
    private String mUploadId;
    private long mUploadOffset = 0L;
    private final long mUploadLength;
    private final Buffer mUploadBuffer = new Buffer();
    private int mChunkSize;
    private int mChunkNum = 0;
    private boolean mIsS3Upload = false;
    private final List<ApiS3FileUploadPart> mS3UploadParts = new ArrayList<ApiS3FileUploadPart>();
    private boolean mIsCompleted = false;
    private boolean mIsClosed = false;
    private Thread mThread;
    private long mProgressUpdateTime = System.currentTimeMillis();
    private final List<FileUploadCallback> mCallbacks = new ArrayList<FileUploadCallback>();

    private UploadStream(DracoonClientImpl client, String id, FileUploadRequest request, long length, UserPublicKey userPublicKey, PlainFileKey fileKey) {
        this.mClient = client;
        this.mLog = client.getLog();
        this.mService = client.getDracoonService();
        this.mHttpClient = client.getHttpClient();
        this.mHttpHelper = client.getHttpHelper();
        this.mErrorParser = client.getDracoonErrorParser();
        this.mCrypto = client.getCryptoWrapper();
        this.mId = id;
        this.mFileUploadRequest = request;
        this.mUploadLength = length;
        this.mUserPublicKey = userPublicKey;
        this.mFileKey = fileKey;
        this.mChunkSize = client.getHttpConfig().getChunkSize() * 1024;
    }

    void start() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        this.mThread = Thread.currentThread();
        try {
            this.notifyStarted(this.mId);
            if (this.isEncryptedUpload()) {
                this.mEncryptionCipher = this.createEncryptionCipher();
            }
            this.mIsS3Upload = this.checkIsS3Upload();
            if (this.mIsS3Upload) {
                this.mChunkSize = Math.max(this.mChunkSize, this.mClient.getS3DefaultChunkSize());
            }
            this.mUploadId = this.createUpload();
        }
        catch (InterruptedException e) {
            this.notifyCanceled(this.mId);
            this.mThread.interrupt();
        }
        catch (DracoonException e) {
            this.notifyFailed(this.mId, e);
            throw e;
        }
    }

    private boolean isEncryptedUpload() {
        return this.mFileKey != null;
    }

    public void addCallback(FileUploadCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
    }

    public void removeCallback(FileUploadCallback callback) {
        if (callback != null) {
            this.mCallbacks.remove(callback);
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] ba = new byte[]{(byte)b};
        this.write(ba);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.assertStarted();
        this.assertNotCompleted();
        this.assertNotClosed();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.mUploadBuffer.write(b, off, len);
        try {
            this.uploadData(true);
        }
        catch (InterruptedException e) {
            this.notifyCanceled(this.mId);
            this.mThread.interrupt();
        }
        catch (DracoonException e) {
            this.notifyFailed(this.mId, e);
            throw new IOException("Could not write to upload stream.", e);
        }
    }

    @Override
    public Node complete() throws IOException {
        Node node;
        this.assertStarted();
        this.assertNotCompleted();
        this.assertNotClosed();
        try {
            this.uploadData(false);
        }
        catch (InterruptedException e) {
            this.notifyCanceled(this.mId);
            this.mThread.interrupt();
            return null;
        }
        catch (DracoonException e) {
            this.notifyFailed(this.mId, e);
            throw new IOException("Could not write to upload stream.", e);
        }
        EncryptedFileKey encryptedFileKey = null;
        try {
            if (this.isEncryptedUpload()) {
                encryptedFileKey = this.mCrypto.encryptFileKey(null, this.mFileKey, this.mUserPublicKey);
            }
        }
        catch (DracoonException e) {
            this.notifyFailed(this.mId, e);
            throw new IOException("Could not complete upload.", e);
        }
        try {
            node = this.completeUpload(encryptedFileKey);
        }
        catch (InterruptedException e) {
            this.notifyCanceled(this.mId);
            this.mThread.interrupt();
            return null;
        }
        catch (DracoonException e) {
            this.notifyFailed(this.mId, e);
            throw new IOException("Could not close upload stream.", e);
        }
        this.notifyFinished(this.mId, node);
        this.mIsCompleted = true;
        return node;
    }

    @Override
    public void close() throws IOException {
        this.assertNotClosed();
        this.mIsClosed = true;
    }

    private FileEncryptionCipher createEncryptionCipher() throws DracoonCryptoException {
        try {
            return this.mCrypto.createFileEncryptionCipher(this.mFileKey);
        }
        catch (CryptoException e) {
            String errorText = UploadStream.createEncryptionErrorMessage(this.mId, (Exception)((Object)e));
            this.mLog.d(LOG_TAG, errorText);
            DracoonCryptoCode errorCode = CryptoErrorParser.parseCause((Exception)((Object)e));
            throw new DracoonCryptoException(errorCode, (Throwable)e);
        }
    }

    private boolean checkIsS3Upload() throws DracoonNetIOException, DracoonApiException {
        retrofit2.Call<ApiServerGeneralSettings> call = this.mService.getServerGeneralSettings();
        retrofit2.Response<ApiServerGeneralSettings> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = UploadStream.createQuerySettingsErrorMessage(errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiServerGeneralSettings settings = (ApiServerGeneralSettings)response.body();
        return settings.useS3Storage != null && settings.useS3Storage != false;
    }

    private String createUpload() throws DracoonNetIOException, DracoonApiException, InterruptedException {
        retrofit2.Call<ApiFileUpload> call;
        retrofit2.Response<ApiFileUpload> response;
        Integer classification = this.mFileUploadRequest.getClassification() != null ? Integer.valueOf(this.mFileUploadRequest.getClassification().getValue()) : null;
        ApiCreateFileUploadRequest request = new ApiCreateFileUploadRequest();
        request.parentId = this.mFileUploadRequest.getParentId();
        request.name = this.mFileUploadRequest.getName();
        request.classification = classification;
        request.notes = this.mFileUploadRequest.getNotes();
        if (this.mFileUploadRequest.getExpirationDate() != null) {
            ApiExpiration apiExpiration = new ApiExpiration();
            apiExpiration.enableExpiration = this.mFileUploadRequest.getExpirationDate().getTime() != 0L;
            apiExpiration.expireAt = this.mFileUploadRequest.getExpirationDate();
            request.expiration = apiExpiration;
        }
        request.timestampCreation = this.mFileUploadRequest.getOriginalCreationDate();
        request.timestampModification = this.mFileUploadRequest.getOriginalModificationDate();
        if (this.mIsS3Upload) {
            request.directS3Upload = this.mIsS3Upload;
        }
        if (!(response = this.mHttpHelper.executeRequest(call = this.mService.createFileUpload(request), this.mThread)).isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUploadCreateError(response);
            String errorText = UploadStream.createStartUploadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return ((ApiFileUpload)response.body()).uploadId;
    }

    private void uploadData(boolean more) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException, InterruptedException {
        while (more && this.mUploadBuffer.size() > (long)this.mChunkSize || !more && this.mUploadBuffer.size() > 0L) {
            byte[] bytes;
            long remaining = this.mUploadBuffer.size();
            long size = remaining > (long)this.mChunkSize ? (long)this.mChunkSize : remaining;
            try {
                bytes = this.mUploadBuffer.readByteArray(size);
            }
            catch (IOException e) {
                String errorText = "Buffer read failed!";
                this.mLog.d(LOG_TAG, errorText);
                throw new DracoonFileIOException(errorText, e);
            }
            if (this.isEncryptedUpload()) {
                boolean isLast = !more && this.mUploadBuffer.size() == 0L;
                bytes = this.encryptBytes(bytes, isLast);
            }
            int count = bytes.length;
            this.mLog.d(LOG_TAG, String.format("Loading: id='%s': chunk=%d: %d-%d", this.mId, this.mChunkNum, this.mUploadOffset, this.mUploadOffset + (long)count));
            this.uploadChunk(this.mUploadOffset, this.mChunkNum, bytes);
            this.mUploadOffset += (long)bytes.length;
            ++this.mChunkNum;
        }
    }

    private byte[] encryptBytes(byte[] bytes, boolean isLast) throws DracoonFileIOException, DracoonCryptoException {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PlainDataContainer plainData = new PlainDataContainer(bytes);
            EncryptedDataContainer encData = this.mEncryptionCipher.processBytes(plainData);
            os.write(encData.getContent());
            if (isLast) {
                encData = this.mEncryptionCipher.doFinal();
                os.write(encData.getContent());
                this.mFileKey.setTag(encData.getTag());
            }
            byArray = os.toByteArray();
        }
        catch (Throwable plainData) {
            try {
                try {
                    os.close();
                }
                catch (Throwable encData) {
                    plainData.addSuppressed(encData);
                }
                throw plainData;
            }
            catch (CryptoSystemException | IllegalArgumentException | IllegalStateException e) {
                String errorText = UploadStream.createEncryptionErrorMessage(this.mId, (Exception)e);
                this.mLog.d(LOG_TAG, errorText);
                DracoonCryptoCode errorCode = CryptoErrorParser.parseCause((Exception)e);
                throw new DracoonCryptoException(errorCode, e);
            }
            catch (IOException e) {
                String errorText = "Buffer write failed!";
                this.mLog.d(LOG_TAG, errorText);
                throw new DracoonFileIOException(errorText, e);
            }
        }
        os.close();
        return byArray;
    }

    private void uploadChunk(long uploadOffset, int chunkNum, byte[] bytes) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        if (this.mIsS3Upload) {
            ApiS3FileUploadPart uploadPart = this.uploadS3Chunk(chunkNum, bytes);
            this.mS3UploadParts.add(uploadPart);
        } else {
            this.uploadStandardChunk(uploadOffset, bytes);
        }
    }

    private Node completeUpload(EncryptedFileKey encryptedFileKey) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        if (this.mIsS3Upload) {
            if (this.mS3UploadParts.isEmpty()) {
                ApiS3FileUploadPart uploadPart = this.uploadS3Chunk(0, new byte[0]);
                this.mS3UploadParts.add(uploadPart);
            }
            return this.completeS3Upload(this.mS3UploadParts, encryptedFileKey);
        }
        return this.completeStandardUpload(encryptedFileKey);
    }

    private void uploadStandardChunk(long offset, byte[] chunk) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        String fileName = this.mFileUploadRequest.getName();
        FileRequestBody fileChunk = this.createChunk(chunk);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)fileName, (RequestBody)fileChunk);
        String contentRange = "bytes " + offset + "-" + (offset + (long)chunk.length) + "/*";
        retrofit2.Call<Void> call = this.mService.uploadFile(this.mUploadId, contentRange, body);
        retrofit2.Response<Void> response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUploadError(response);
            String errorText = UploadStream.createUploadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    private Node completeStandardUpload(EncryptedFileKey encryptedFileKey) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        ApiCompleteFileUploadRequest request = new ApiCompleteFileUploadRequest();
        request.fileName = this.mFileUploadRequest.getName();
        request.resolutionStrategy = this.mFileUploadRequest.getResolutionStrategy().getValue();
        request.fileKey = FileMapper.toApiFileKey(encryptedFileKey);
        retrofit2.Call<ApiNode> call = this.mService.completeFileUpload(this.mUploadId, request);
        retrofit2.Response<ApiNode> response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseUploadCompleteError(response);
            String errorText = UploadStream.createCompleteUploadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return NodeMapper.fromApiNode((ApiNode)response.body());
    }

    private ApiS3FileUploadPart uploadS3Chunk(int chunkNum, byte[] chunk) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        String uploadUrl = this.getS3UploadUrl(chunkNum, chunk.length);
        FileRequestBody fileChunk = this.createChunk(chunk);
        Request request = new Request.Builder().url(uploadUrl).put((RequestBody)fileChunk).build();
        Call call = this.mHttpClient.newCall(request);
        Response response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseS3UploadError(response);
            String errorText = UploadStream.createUploadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        String eTag = response.headers().get(S3_ETAG_HEADER);
        eTag = eTag != null ? eTag.replace("\"", "") : "";
        ApiS3FileUploadPart part = new ApiS3FileUploadPart();
        part.partNumber = chunkNum + 1;
        part.partEtag = eTag;
        return part;
    }

    private String getS3UploadUrl(int chunkNum, long chunkSize) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        this.mLog.d(LOG_TAG, String.format("Requesting S3 upload URL: chunk=%d: size=%d: ", chunkNum, chunkSize));
        ApiGetS3FileUploadUrlsRequest request = new ApiGetS3FileUploadUrlsRequest();
        request.size = chunkSize;
        request.firstPartNumber = chunkNum + 1;
        request.lastPartNumber = chunkNum + 1;
        retrofit2.Call<ApiS3FileUploadUrlList> call = this.mService.getS3FileUploadUrls(this.mUploadId, request);
        retrofit2.Response<ApiS3FileUploadUrlList> response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseS3UploadGetUrlsError(response);
            String errorText = UploadStream.createUploadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return ((ApiS3FileUploadUrlList)response.body()).urls.get((int)0).url;
    }

    private Node completeS3Upload(List<ApiS3FileUploadPart> uploadParts, EncryptedFileKey encryptedFileKey) throws DracoonNetIOException, DracoonApiException, InterruptedException {
        ApiCompleteS3FileUploadRequest request = new ApiCompleteS3FileUploadRequest();
        request.fileName = this.mFileUploadRequest.getName();
        request.parts = uploadParts;
        request.resolutionStrategy = this.mFileUploadRequest.getResolutionStrategy().getValue();
        request.fileKey = FileMapper.toApiFileKey(encryptedFileKey);
        retrofit2.Call<Void> call = this.mService.completeS3FileUpload(this.mUploadId, request);
        retrofit2.Response<Void> response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseS3UploadCompleteError(response);
            String errorText = UploadStream.createCompleteUploadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        Node node = null;
        for (long completeWaitTime = 500L; completeWaitTime < 5000L && (node = this.waitForCompleteS3Upload()) == null; completeWaitTime *= 2L) {
            Thread.sleep(completeWaitTime);
        }
        return node;
    }

    private Node waitForCompleteS3Upload() throws DracoonNetIOException, DracoonApiException, InterruptedException {
        retrofit2.Call<ApiS3FileUploadStatus> call = this.mService.getS3FileUploadStatus(this.mUploadId);
        retrofit2.Response<ApiS3FileUploadStatus> response = this.mHttpHelper.executeRequest(call, this.mThread);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseS3UploadStatusError(response);
            String errorText = UploadStream.createCompleteUploadErrorMessage(this.mId, errorCode);
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiS3FileUploadStatus uploadStatus = (ApiS3FileUploadStatus)response.body();
        switch (uploadStatus.status) {
            case "transfer": 
            case "finishing": {
                return null;
            }
            case "done": {
                return NodeMapper.fromApiNode(uploadStatus.node);
            }
        }
        DracoonApiCode errorCode = this.mErrorParser.parseS3UploadStatusError(uploadStatus.errorDetails);
        String errorText = UploadStream.createCompleteUploadErrorMessage(this.mId, errorCode);
        this.mLog.d(LOG_TAG, errorText);
        throw new DracoonApiException(errorCode);
    }

    private FileRequestBody createChunk(byte[] chunk) {
        FileRequestBody requestBody = new FileRequestBody(chunk, chunk.length);
        requestBody.setCallback(send -> {
            if (this.mProgressUpdateTime + 100L < System.currentTimeMillis() && !this.mThread.isInterrupted()) {
                this.notifyRunning(this.mId, this.mUploadOffset + send, this.mUploadLength);
                this.mProgressUpdateTime = System.currentTimeMillis();
            }
        });
        return requestBody;
    }

    private void assertStarted() throws IOException {
        if (this.mUploadId == null) {
            throw new IOException("Upload stream was not started.");
        }
    }

    private void assertNotCompleted() throws IOException {
        if (this.mIsCompleted) {
            throw new IOException("Upload stream was already completed.");
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.mIsClosed) {
            throw new IOException("Upload stream was already closed.");
        }
    }

    private void notifyStarted(String id) {
        for (FileUploadCallback callback : this.mCallbacks) {
            callback.onStarted(id);
        }
    }

    private void notifyRunning(String id, long bytesSend, long bytesTotal) {
        for (FileUploadCallback callback : this.mCallbacks) {
            callback.onRunning(id, bytesSend, bytesTotal);
        }
    }

    private void notifyFinished(String id, Node node) {
        for (FileUploadCallback callback : this.mCallbacks) {
            callback.onFinished(id, node);
        }
    }

    private void notifyCanceled(String id) {
        for (FileUploadCallback callback : this.mCallbacks) {
            callback.onCanceled(id);
        }
    }

    private void notifyFailed(String id, DracoonException e) {
        for (FileUploadCallback callback : this.mCallbacks) {
            callback.onFailed(id, e);
        }
    }

    private static String createQuerySettingsErrorMessage(DracoonApiCode errorCode) {
        return String.format("Query of server general settings failed with '%s'!", errorCode.name());
    }

    private static String createEncryptionErrorMessage(String id, Exception e) {
        return String.format("Encryption failed at upload of '%s'! %s", id, e.getMessage());
    }

    private static String createStartUploadErrorMessage(String id, DracoonApiCode errorCode) {
        return String.format("Creation of upload stream for '%s' failed with '%s'!", id, errorCode.name());
    }

    private static String createUploadErrorMessage(String id, DracoonApiCode errorCode) {
        return String.format("Upload of '%s' failed with '%s'!", id, errorCode.name());
    }

    private static String createCompleteUploadErrorMessage(String id, DracoonApiCode errorCode) {
        return String.format("Completion of upload for '%s' failed with '%s'!", id, errorCode.name());
    }

    public static UploadStream create(DracoonClientImpl client, String id, FileUploadRequest request, long length, UserPublicKey userPublicKey, PlainFileKey fileKey) {
        return new UploadStream(client, id, request, length, userPublicKey, fileKey);
    }

    private static class FileRequestBody
    extends RequestBody {
        private final byte[] mData;
        private final int mLength;
        private Callback mCallback;

        FileRequestBody(byte[] data, int length) {
            this.mData = data;
            this.mLength = length;
        }

        void setCallback(Callback callback) {
            this.mCallback = callback;
        }

        public MediaType contentType() {
            return MediaType.parse((String)"application/octet-stream");
        }

        public long contentLength() throws IOException {
            return this.mLength;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int remaining;
            int offset = 0;
            while ((remaining = this.mLength - offset) > 0) {
                int count = remaining >= 2048 ? 2048 : remaining;
                sink.write(this.mData, offset, count);
                offset += count;
                if (this.mCallback == null) continue;
                this.mCallback.onProgress(offset);
            }
        }

        static interface Callback {
            public void onProgress(long var1);
        }
    }
}

