/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.mapper;

import com.dracoon.sdk.internal.mapper.BaseMapper;
import com.dracoon.sdk.internal.model.ApiEncryptionPasswordPolicies;
import com.dracoon.sdk.internal.model.ApiServerClassificationPolicies;
import com.dracoon.sdk.internal.model.ApiServerDefaults;
import com.dracoon.sdk.internal.model.ApiServerGeneralSettings;
import com.dracoon.sdk.internal.model.ApiServerShareClassificationPolicies;
import com.dracoon.sdk.internal.model.ApiSharesPasswordPolicies;
import com.dracoon.sdk.model.Classification;
import com.dracoon.sdk.model.ClassificationPolicies;
import com.dracoon.sdk.model.PasswordPolicies;
import com.dracoon.sdk.model.PasswordPoliciesCharacterType;
import com.dracoon.sdk.model.ServerDefaults;
import com.dracoon.sdk.model.ServerGeneralSettings;
import com.dracoon.sdk.model.ShareClassificationPolicies;
import java.util.ArrayList;
import java.util.List;

public class ServerMapper
extends BaseMapper {
    private ServerMapper() {
    }

    public static ServerGeneralSettings fromApiGeneralSettings(ApiServerGeneralSettings apiServerGeneralSettings) {
        if (apiServerGeneralSettings == null) {
            return null;
        }
        ServerGeneralSettings serverGeneralSettings = new ServerGeneralSettings();
        serverGeneralSettings.setSharePasswordSmsEnabled(ServerMapper.toBoolean(apiServerGeneralSettings.sharePasswordSmsEnabled));
        serverGeneralSettings.setCryptoEnabled(ServerMapper.toBoolean(apiServerGeneralSettings.cryptoEnabled));
        serverGeneralSettings.setMediaServerEnabled(ServerMapper.toBoolean(apiServerGeneralSettings.mediaServerEnabled));
        serverGeneralSettings.setWeakPasswordEnabled(ServerMapper.toBoolean(apiServerGeneralSettings.weakPasswordEnabled));
        return serverGeneralSettings;
    }

    public static ServerDefaults fromApiServerDefaults(ApiServerDefaults apiServerDefaults) {
        if (apiServerDefaults == null) {
            return null;
        }
        ServerDefaults serverDefaults = new ServerDefaults();
        serverDefaults.setDownloadShareExpirationPeriod(apiServerDefaults.downloadShareDefaultExpirationPeriod);
        serverDefaults.setUploadShareExpirationPeriod(apiServerDefaults.uploadShareDefaultExpirationPeriod);
        serverDefaults.setFileExpirationPeriod(apiServerDefaults.fileDefaultExpirationPeriod);
        return serverDefaults;
    }

    public static PasswordPolicies fromApiEncryptionPasswordPolicies(ApiEncryptionPasswordPolicies apiEncryptionPasswordPolicies) {
        if (apiEncryptionPasswordPolicies == null) {
            return null;
        }
        PasswordPolicies policies = new PasswordPolicies();
        policies.setMinLength(apiEncryptionPasswordPolicies.minLength);
        policies.setCharacterTypes(ServerMapper.fromApiCharacterTypes(apiEncryptionPasswordPolicies.characterRules.mustContainCharacters));
        policies.setRejectUserInfo(ServerMapper.toBoolean(apiEncryptionPasswordPolicies.rejectUserInfo));
        policies.setRejectKeyboardPatterns(ServerMapper.toBoolean(apiEncryptionPasswordPolicies.rejectKeyboardPatterns));
        policies.setRejectDictionaryWords(false);
        return policies;
    }

    public static PasswordPolicies fromApiSharesPasswordPolicies(ApiSharesPasswordPolicies apiSharesPasswordPolicies) {
        if (apiSharesPasswordPolicies == null) {
            return null;
        }
        PasswordPolicies policies = new PasswordPolicies();
        policies.setMinLength(apiSharesPasswordPolicies.minLength);
        policies.setCharacterTypes(ServerMapper.fromApiCharacterTypes(apiSharesPasswordPolicies.characterRules.mustContainCharacters));
        policies.setRejectUserInfo(ServerMapper.toBoolean(apiSharesPasswordPolicies.rejectUserInfo));
        policies.setRejectKeyboardPatterns(ServerMapper.toBoolean(apiSharesPasswordPolicies.rejectKeyboardPatterns));
        policies.setRejectDictionaryWords(ServerMapper.toBoolean(apiSharesPasswordPolicies.rejectDictionaryWords));
        return policies;
    }

    private static List<PasswordPoliciesCharacterType> fromApiCharacterTypes(List<String> apiCharacterTypes) {
        if (apiCharacterTypes == null) {
            return new ArrayList<PasswordPoliciesCharacterType>();
        }
        ArrayList<PasswordPoliciesCharacterType> characterTypes = new ArrayList<PasswordPoliciesCharacterType>();
        for (String apiCharacterType : apiCharacterTypes) {
            if (apiCharacterType.equals("all")) {
                characterTypes.add(PasswordPoliciesCharacterType.LOWERCASE);
                characterTypes.add(PasswordPoliciesCharacterType.UPPERCASE);
                characterTypes.add(PasswordPoliciesCharacterType.NUMERIC);
                characterTypes.add(PasswordPoliciesCharacterType.SPECIAL);
                break;
            }
            PasswordPoliciesCharacterType characterType = PasswordPoliciesCharacterType.getByValue(apiCharacterType);
            if (characterType == null) continue;
            characterTypes.add(characterType);
        }
        return characterTypes;
    }

    public static ClassificationPolicies fromApiClassificationPolicies(ApiServerClassificationPolicies apiServerClassificationPolicies) {
        if (apiServerClassificationPolicies == null) {
            return null;
        }
        ClassificationPolicies policies = new ClassificationPolicies();
        policies.setShareClassificationPolicies(ServerMapper.fromApiShareClassificationPolicies(apiServerClassificationPolicies.shareClassificationPolicies));
        return policies;
    }

    private static ShareClassificationPolicies fromApiShareClassificationPolicies(ApiServerShareClassificationPolicies apiServerShareClassificationPolicies) {
        if (apiServerShareClassificationPolicies == null) {
            return null;
        }
        ShareClassificationPolicies policies = new ShareClassificationPolicies();
        if (apiServerShareClassificationPolicies.classificationRequiresSharePassword != null) {
            policies.setRequirePasswordClassification(Classification.getByValue(apiServerShareClassificationPolicies.classificationRequiresSharePassword));
        }
        return policies;
    }
}

