/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.oauth;

import com.dracoon.sdk.DracoonHttpConfig;
import com.dracoon.sdk.Log;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.HttpHelper;
import com.dracoon.sdk.internal.NullLog;
import com.dracoon.sdk.internal.UserAgentInterceptor;
import com.dracoon.sdk.internal.oauth.OAuthErrorParser;
import com.dracoon.sdk.internal.oauth.OAuthService;
import com.dracoon.sdk.internal.oauth.OAuthTokens;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class OAuthClient {
    private static final String LOG_TAG = OAuthClient.class.getSimpleName();
    private final URL mServerUrl;
    private final String mClientId;
    private final String mClientSecret;
    private Log mLog = new NullLog();
    private DracoonHttpConfig mHttpConfig = new DracoonHttpConfig();
    private OkHttpClient mHttpClient;
    private OAuthService mOAuthService;
    private OAuthErrorParser mOAuthErrorParser;
    private HttpHelper mHttpHelper;

    public OAuthClient(URL serverUrl, String clientId, String clientSecret) {
        this.mServerUrl = serverUrl;
        this.mClientId = clientId;
        this.mClientSecret = clientSecret;
    }

    public void setLog(Log log) {
        this.mLog = log != null ? log : new NullLog();
    }

    public void setHttpConfig(DracoonHttpConfig httpConfig) {
        this.mHttpConfig = httpConfig != null ? httpConfig : new DracoonHttpConfig();
    }

    public void init() {
        this.initHttpClient();
        this.initOAuthService();
        this.initOAuthErrorParser();
        this.initHttpHelper();
    }

    private void initHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)this.mHttpConfig.getConnectTimeout(), TimeUnit.SECONDS);
        builder.readTimeout((long)this.mHttpConfig.getReadTimeout(), TimeUnit.SECONDS);
        builder.writeTimeout((long)this.mHttpConfig.getWriteTimeout(), TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(true);
        builder.followRedirects(false);
        if (this.mHttpConfig.isProxyEnabled()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.mHttpConfig.getProxyAddress(), (int)this.mHttpConfig.getProxyPort()));
            builder.proxy(proxy);
        }
        for (Interceptor interceptor : this.mHttpConfig.getOkHttpApplicationInterceptors()) {
            builder.addInterceptor(interceptor);
        }
        builder.addNetworkInterceptor((Interceptor)new UserAgentInterceptor(this.mHttpConfig.getUserAgent()));
        for (Interceptor interceptor : this.mHttpConfig.getOkHttpNetworkInterceptors()) {
            builder.addNetworkInterceptor(interceptor);
        }
        this.mHttpClient = builder.build();
    }

    private void initOAuthService() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.mServerUrl.toString()).client(this.mHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.mOAuthService = (OAuthService)retrofit.create(OAuthService.class);
    }

    private void initOAuthErrorParser() {
        this.mOAuthErrorParser = new OAuthErrorParser();
        this.mOAuthErrorParser.setLog(this.mLog);
    }

    private void initHttpHelper() {
        this.mHttpHelper = new HttpHelper();
        this.mHttpHelper.setLog(this.mLog);
        this.mHttpHelper.setRetryEnabled(this.mHttpConfig.isRetryEnabled());
        this.mHttpHelper.setRateLimitingEnabled(this.mHttpConfig.isRateLimitingEnabled());
        this.mHttpHelper.init();
    }

    public OAuthTokens retrieveTokens(String code) throws DracoonNetIOException, DracoonApiException {
        return this.retrieveTokens(code, null);
    }

    public OAuthTokens retrieveTokens(String code, URI redirectUri) throws DracoonNetIOException, DracoonApiException {
        String auth = Credentials.basic((String)this.mClientId, (String)this.mClientSecret);
        String redirUri = redirectUri != null ? redirectUri.toString() : null;
        this.mLog.i(LOG_TAG, "Trying to retrieve OAuth tokens ...");
        Call<OAuthTokens> call = this.mOAuthService.getOAuthToken(auth, "authorization_code", code, redirUri);
        Response<OAuthTokens> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiException e = this.mOAuthErrorParser.parseTokenError(response);
            this.mLog.d(LOG_TAG, String.format("Retrieval of OAuth tokens failed with '%s'!", e.getCode().name()));
            throw e;
        }
        this.mLog.i(LOG_TAG, "Successfully retrieved OAuth tokens.");
        return (OAuthTokens)response.body();
    }

    public OAuthTokens refreshTokens(String refreshToken) throws DracoonNetIOException, DracoonApiException {
        String auth = Credentials.basic((String)this.mClientId, (String)this.mClientSecret);
        this.mLog.i(LOG_TAG, "Trying to refresh OAuth tokens ...");
        Call<OAuthTokens> call = this.mOAuthService.refreshOAuthToken(auth, "refresh_token", refreshToken);
        Response<OAuthTokens> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiException e = this.mOAuthErrorParser.parseOAuthRefreshError(response);
            this.mLog.d(LOG_TAG, String.format("Refresh of OAuth tokens failed with '%s'!", e.getCode().name()));
            throw e;
        }
        this.mLog.i(LOG_TAG, "Successfully refreshed OAuth tokens.");
        return (OAuthTokens)response.body();
    }

    public void revokeAccessToken(String accessToken) throws DracoonNetIOException, DracoonApiException {
        this.mLog.i(LOG_TAG, "Trying to revoke OAuth access token ...");
        try {
            this.revokeToken("access_token", accessToken);
        }
        catch (DracoonApiException e) {
            this.mLog.d(LOG_TAG, String.format("Revocation of OAuth access token failed with '%s'!", e.getCode().name()));
            throw e;
        }
        this.mLog.i(LOG_TAG, "Successfully revoked OAuth access token.");
    }

    public void revokeRefreshToken(String refreshToken) throws DracoonNetIOException, DracoonApiException {
        this.mLog.i(LOG_TAG, "Trying to revoke OAuth refresh token ...");
        try {
            this.revokeToken("refresh_token", refreshToken);
        }
        catch (DracoonApiException e) {
            this.mLog.d(LOG_TAG, String.format("Revocation of OAuth refresh token failed with '%s'!", e.getCode().name()));
            throw e;
        }
        this.mLog.i(LOG_TAG, "Successfully revoked OAuth refresh token.");
    }

    private void revokeToken(String tokenType, String token) throws DracoonNetIOException, DracoonApiException {
        String auth = Credentials.basic((String)this.mClientId, (String)this.mClientSecret);
        Call<Void> call = this.mOAuthService.revokeOAuthToken(auth, tokenType, token);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            throw this.mOAuthErrorParser.parseOAuthRevokeError(response);
        }
    }
}

