/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.validator;

import com.dracoon.sdk.internal.validator.BaseValidator;
import com.dracoon.sdk.internal.validator.ValidatorUtils;
import com.dracoon.sdk.model.CreateDownloadShareRequest;
import com.dracoon.sdk.model.CreateUploadShareRequest;

public class ShareValidator
extends BaseValidator {
    private ShareValidator() {
    }

    public static void validateCreateDownloadRequest(CreateDownloadShareRequest request, boolean isEncrypted) {
        ValidatorUtils.validateNotNull("Download share creation request", request);
        ShareValidator.validateNodeId(request.getNodeId());
        if (request.getName() != null) {
            ShareValidator.validateName(request.getName());
        }
        if (request.getMaxDownloads() != null) {
            ShareValidator.validateMaxDownloads(request.getMaxDownloads());
        }
        if (isEncrypted && request.getAccessPassword() != null) {
            throw new IllegalArgumentException("Download shares of a encrypted node cannot have a access password.");
        }
        if (!isEncrypted && request.getAccessPassword() != null) {
            ShareValidator.validateAccessPassword(request.getAccessPassword());
        }
        if (!isEncrypted && request.getEncryptionPassword() != null) {
            throw new IllegalArgumentException("Download shares of a not encrypted node cannot have a encryption password.");
        }
        if (isEncrypted && request.getEncryptionPassword() == null) {
            throw new IllegalArgumentException("Download shares of a encrypted node must have a encryption password.");
        }
        if (isEncrypted && request.getEncryptionPassword() != null) {
            ShareValidator.validateEncryptionPassword(request.getEncryptionPassword());
        }
        if (request.sendEmail().booleanValue()) {
            ShareValidator.validateEmailAddresses(request.getEmailRecipients());
            ShareValidator.validateEmailSubject(request.getEmailSubject());
            ShareValidator.validateEmailBody(request.getEmailBody());
        }
        if (request.sendSms().booleanValue()) {
            ShareValidator.validatePhoneNumbers(request.getSmsRecipients());
        }
    }

    public static void validateCreateUploadRequest(CreateUploadShareRequest request) {
        ValidatorUtils.validateNotNull("Download share creation request", request);
        ShareValidator.validateNodeId(request.getTargetNodeId());
        ShareValidator.validateName(request.getName());
        ShareValidator.validatePeriod(request.getFilesExpirationPeriod());
        if (request.getMaxUploads() != null) {
            ShareValidator.validateMaxUploads(request.getMaxUploads());
        }
        if (request.getMaxQuota() != null) {
            ShareValidator.validateQuota(request.getMaxQuota());
        }
        if (request.getAccessPassword() != null) {
            ShareValidator.validateAccessPassword(request.getAccessPassword());
        }
        if (request.sendEmail().booleanValue()) {
            ShareValidator.validateEmailAddresses(request.getEmailRecipients());
            ShareValidator.validateEmailSubject(request.getEmailSubject());
            ShareValidator.validateEmailBody(request.getEmailBody());
        }
        if (request.sendSms().booleanValue()) {
            ShareValidator.validatePhoneNumbers(request.getSmsRecipients());
        }
    }
}

