/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.model;

import java.util.Date;
import java.util.List;

public class CreateDownloadShareRequest {
    private Long mNodeId;
    private String mName;
    private String mNotes;
    private String mInternalNotes;
    private Date mExpirationDate;
    private Integer mMaxDownloads;
    private Boolean mShowCreatorName;
    private Boolean mShowCreatorUserName;
    private Boolean mNotifyCreator;
    private char[] mAccessPassword;
    private char[] mEncryptionPassword;
    private Boolean mSendEmail;
    private List<String> mEmailRecipients;
    private String mEmailSubject;
    private String mEmailBody;
    private Boolean mSendSms;
    private List<String> mSmsRecipients;

    private CreateDownloadShareRequest() {
    }

    public Long getNodeId() {
        return this.mNodeId;
    }

    public String getName() {
        return this.mName;
    }

    public String getNotes() {
        return this.mNotes;
    }

    public String getInternalNotes() {
        return this.mInternalNotes;
    }

    public Date getExpirationDate() {
        return this.mExpirationDate;
    }

    public Integer getMaxDownloads() {
        return this.mMaxDownloads;
    }

    public Boolean showCreatorName() {
        return this.mShowCreatorName;
    }

    public Boolean showCreatorUserName() {
        return this.mShowCreatorUserName;
    }

    public Boolean notifyCreator() {
        return this.mNotifyCreator;
    }

    public char[] getAccessPassword() {
        return this.mAccessPassword;
    }

    public char[] getEncryptionPassword() {
        return this.mEncryptionPassword;
    }

    public Boolean sendEmail() {
        return this.mSendEmail;
    }

    public List<String> getEmailRecipients() {
        return this.mEmailRecipients;
    }

    public String getEmailSubject() {
        return this.mEmailSubject;
    }

    public String getEmailBody() {
        return this.mEmailBody;
    }

    public Boolean sendSms() {
        return this.mSendSms;
    }

    public List<String> getSmsRecipients() {
        return this.mSmsRecipients;
    }

    public static class Builder {
        private final CreateDownloadShareRequest mRequest = new CreateDownloadShareRequest();

        public Builder(Long nodeId) {
            this.mRequest.mNodeId = nodeId;
            this.mRequest.mSendEmail = false;
            this.mRequest.mSendSms = false;
        }

        public Builder name(String name) {
            this.mRequest.mName = name;
            return this;
        }

        public Builder notes(String notes) {
            this.mRequest.mNotes = notes;
            return this;
        }

        public Builder internalNotes(String internalNotes) {
            this.mRequest.mInternalNotes = internalNotes;
            return this;
        }

        public Builder expirationDate(Date expirationDate) {
            this.mRequest.mExpirationDate = expirationDate;
            return this;
        }

        public Builder maxDownloads(Integer maxDownloads) {
            this.mRequest.mMaxDownloads = maxDownloads;
            return this;
        }

        public Builder showCreatorName(Boolean showCreatorName) {
            this.mRequest.mShowCreatorName = showCreatorName;
            return this;
        }

        public Builder showCreatorUserName(Boolean showCreatorUserName) {
            this.mRequest.mShowCreatorUserName = showCreatorUserName;
            return this;
        }

        public Builder notifyCreator(Boolean notifyCreator) {
            this.mRequest.mNotifyCreator = notifyCreator;
            return this;
        }

        public Builder accessPassword(char[] accessPassword) {
            this.mRequest.mAccessPassword = accessPassword;
            return this;
        }

        public Builder encryptionPassword(char[] encryptionPassword) {
            this.mRequest.mEncryptionPassword = encryptionPassword;
            return this;
        }

        public Builder sendEmail(List<String> recipients, String subject, String body) {
            this.mRequest.mSendEmail = true;
            this.mRequest.mEmailRecipients = recipients;
            this.mRequest.mEmailSubject = subject;
            this.mRequest.mEmailBody = body;
            return this;
        }

        public Builder sendSms(List<String> recipients) {
            this.mRequest.mSendSms = true;
            this.mRequest.mSmsRecipients = recipients;
            return this;
        }

        public CreateDownloadShareRequest build() {
            return this.mRequest;
        }
    }
}

