/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.model;

import com.dracoon.sdk.model.Classification;
import com.dracoon.sdk.model.ResolutionStrategy;
import java.util.Date;

public class FileUploadRequest {
    private Long mParentId;
    private String mName;
    private ResolutionStrategy mResolutionStrategy;
    private Classification mClassification;
    private String mNotes;
    private Date mExpirationDate;
    private Date mOriginalCreationDate;
    private Date mOriginalModificationDate;

    private FileUploadRequest() {
    }

    public Long getParentId() {
        return this.mParentId;
    }

    public String getName() {
        return this.mName;
    }

    public ResolutionStrategy getResolutionStrategy() {
        return this.mResolutionStrategy;
    }

    public Classification getClassification() {
        return this.mClassification;
    }

    public String getNotes() {
        return this.mNotes;
    }

    public Date getExpirationDate() {
        return this.mExpirationDate;
    }

    public Date getOriginalCreationDate() {
        return this.mOriginalCreationDate;
    }

    public Date getOriginalModificationDate() {
        return this.mOriginalModificationDate;
    }

    public static class Builder {
        private final FileUploadRequest mRequest = new FileUploadRequest();

        public Builder(Long parentId, String name) {
            this.mRequest.mParentId = parentId;
            this.mRequest.mName = name;
            this.mRequest.mResolutionStrategy = ResolutionStrategy.AUTO_RENAME;
        }

        public Builder resolutionStrategy(ResolutionStrategy resolutionStrategy) {
            this.mRequest.mResolutionStrategy = resolutionStrategy;
            return this;
        }

        public Builder classification(Classification classification) {
            this.mRequest.mClassification = classification;
            return this;
        }

        public Builder notes(String notes) {
            this.mRequest.mNotes = notes;
            return this;
        }

        public Builder expirationDate(Date expirationDate) {
            this.mRequest.mExpirationDate = expirationDate;
            return this;
        }

        public Builder originalCreationDate(Date originalCreationDate) {
            this.mRequest.mOriginalCreationDate = originalCreationDate;
            return this;
        }

        public Builder originalModificationDate(Date originalModificationDate) {
            this.mRequest.mOriginalModificationDate = originalModificationDate;
            return this;
        }

        public FileUploadRequest build() {
            return this.mRequest;
        }
    }
}

