/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.model;

import com.dracoon.sdk.model.ResolutionStrategy;
import java.util.ArrayList;
import java.util.List;

public class MoveNodesRequest {
    private Long mTargetNodeId;
    private List<SourceNode> mSourceNodes;
    private ResolutionStrategy mResolutionStrategy;

    private MoveNodesRequest() {
    }

    public Long getTargetNodeId() {
        return this.mTargetNodeId;
    }

    public List<SourceNode> getSourceNodes() {
        return this.mSourceNodes;
    }

    public ResolutionStrategy getResolutionStrategy() {
        return this.mResolutionStrategy;
    }

    public static class Builder {
        private final MoveNodesRequest mRequest = new MoveNodesRequest();

        public Builder(Long targetNodeId) {
            this.mRequest.mTargetNodeId = targetNodeId;
            this.mRequest.mSourceNodes = new ArrayList<SourceNode>();
            this.mRequest.mResolutionStrategy = ResolutionStrategy.AUTO_RENAME;
        }

        public Builder addSourceNode(Long sourceNodeId) {
            this.mRequest.mSourceNodes.add(new SourceNode(sourceNodeId));
            return this;
        }

        public Builder addSourceNode(Long sourceNodeId, String newNodeName) {
            this.mRequest.mSourceNodes.add(new SourceNode(sourceNodeId, newNodeName));
            return this;
        }

        public Builder resolutionStrategy(ResolutionStrategy resolutionStrategy) {
            this.mRequest.mResolutionStrategy = resolutionStrategy;
            return this;
        }

        public MoveNodesRequest build() {
            return this.mRequest;
        }
    }

    public static class SourceNode {
        private final Long mId;
        private final String mName;

        SourceNode(Long id) {
            this.mId = id;
            this.mName = null;
        }

        SourceNode(Long id, String name) {
            this.mId = id;
            this.mName = name;
        }

        public Long getId() {
            return this.mId;
        }

        public String getName() {
            return this.mName;
        }
    }
}

