/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk;

import com.dracoon.sdk.internal.BuildDetails;
import com.dracoon.sdk.internal.validator.ValidatorUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;

public class DracoonHttpConfig {
    private static final int MIN_CHUNK_SIZE = 5120;
    private String mUserAgent;
    private boolean mRetryEnabled = false;
    private boolean mRateLimitingEnabled = false;
    private int mConnectTimeout = 15;
    private int mReadTimeout = 15;
    private int mWriteTimeout = 15;
    private int mChunkSize = 5120;
    private boolean mProxyEnabled = false;
    private InetAddress mProxyAddress;
    private Integer mProxyPort;
    private final List<Interceptor> mOkHttpApplicationInterceptors = new ArrayList<Interceptor>();
    private final List<Interceptor> mOkHttpNetworkInterceptors = new ArrayList<Interceptor>();

    public DracoonHttpConfig() {
        this.mUserAgent = DracoonHttpConfig.buildDefaultUserAgentString();
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public boolean isRetryEnabled() {
        return this.mRetryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.mRetryEnabled = retryEnabled;
    }

    public boolean isRateLimitingEnabled() {
        return this.mRateLimitingEnabled;
    }

    public void setRateLimitingEnabled(boolean rateLimitingEnabled) {
        this.mRateLimitingEnabled = rateLimitingEnabled;
    }

    public int getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.mConnectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.mReadTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.mWriteTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.mWriteTimeout = writeTimeout;
    }

    public int getChunkSize() {
        return this.mChunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.mChunkSize = chunkSize > 5120 ? chunkSize : 5120;
    }

    public void setProxy(InetAddress address, Integer port) {
        ValidatorUtils.validateNotNull("Address", address);
        ValidatorUtils.validateNotNull("Port", port);
        this.mProxyEnabled = true;
        this.mProxyAddress = address;
        this.mProxyPort = port;
    }

    public boolean isProxyEnabled() {
        return this.mProxyEnabled;
    }

    public InetAddress getProxyAddress() {
        return this.mProxyAddress;
    }

    public Integer getProxyPort() {
        return this.mProxyPort;
    }

    public List<Interceptor> getOkHttpApplicationInterceptors() {
        return this.mOkHttpApplicationInterceptors;
    }

    public void addOkHttpApplicationInterceptor(Interceptor interceptor) {
        ValidatorUtils.validateNotNull("OkHttp application interceptor", interceptor);
        this.mOkHttpApplicationInterceptors.add(interceptor);
    }

    public List<Interceptor> getOkHttpNetworkInterceptors() {
        return this.mOkHttpNetworkInterceptors;
    }

    public void addOkHttpNetworkInterceptor(Interceptor interceptor) {
        ValidatorUtils.validateNotNull("OkHttp network interceptor", interceptor);
        this.mOkHttpNetworkInterceptors.add(interceptor);
    }

    private static String buildDefaultUserAgentString() {
        return "Java-SDK|" + BuildDetails.getVersion() + "|-|-|" + BuildDetails.getBuildTimestamp();
    }
}

