/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk;

import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.internal.oauth.OAuthErrorParser;
import com.dracoon.sdk.internal.validator.ValidatorUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class OAuthHelper {
    private static final OAuthErrorParser sErrorParser = new OAuthErrorParser();

    private OAuthHelper() {
    }

    public static String createAuthorizationUrl(URL serverUrl, String clientId, String state) {
        return OAuthHelper.createAuthorizationUrlInternally(serverUrl, clientId, state, null);
    }

    public static String createAuthorizationUrl(URL serverUrl, String clientId, String state, URI redirectUri) {
        ValidatorUtils.validateNotNull("Redirect URI", redirectUri);
        return OAuthHelper.createAuthorizationUrlInternally(serverUrl, clientId, state, redirectUri);
    }

    private static String createAuthorizationUrlInternally(URL serverUrl, String clientId, String state, URI redirectUri) {
        ValidatorUtils.validateServerURL(serverUrl);
        ValidatorUtils.validateString("Client ID", clientId, false);
        ValidatorUtils.validateString("State", state, false);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(serverUrl).append("/oauth").append("/authorize");
        urlBuilder.append("?");
        urlBuilder.append("response_type=").append("code");
        urlBuilder.append("&client_id=").append(clientId);
        urlBuilder.append("&state=").append(state);
        if (redirectUri != null) {
            try {
                String encodedRedirectUri = URLEncoder.encode(redirectUri.toString(), StandardCharsets.UTF_8.toString());
                urlBuilder.append("&redirect_uri=").append(encodedRedirectUri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return urlBuilder.toString();
    }

    public static String extractAuthorizationStateFromUri(URI uri) throws DracoonApiException {
        return OAuthHelper.extractAuthorizationDataFromUri(uri, "state");
    }

    public static String extractAuthorizationCodeFromUri(URI uri) throws DracoonApiException {
        return OAuthHelper.extractAuthorizationDataFromUri(uri, "code");
    }

    private static String extractAuthorizationDataFromUri(URI uri, String name) throws DracoonApiException {
        ValidatorUtils.validateNotNull("Redirect URI", uri);
        String query = uri.getQuery();
        Map<String, String> queryParams = OAuthHelper.parseQuery(query);
        String error = queryParams.get("error");
        if (error != null) {
            throw sErrorParser.parseAuthorizeError(error);
        }
        return queryParams.get(name);
    }

    private static Map<String, String> parseQuery(String query) {
        String[] params;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : params = query != null ? query.split("&") : new String[]{}) {
            String v;
            String[] kv = param.split("=");
            String k = kv.length > 0 ? kv[0] : null;
            String string = v = kv.length > 1 ? kv[1] : null;
            if (k == null) continue;
            result.put(k, v);
        }
        return result;
    }
}

