/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.error;

public enum DracoonCryptoCode {
    MISSING_PASSWORD_ERROR(-1, "No password has been provided."),
    INVALID_PASSWORD_ERROR(-2, "The provided password is invalid."),
    BAD_FILE_ERROR(-3, "The file integrity check failed. It may have been modified."),
    UNKNOWN_ALGORITHM_VERSION_ERROR(-4, "The crypto algorithm version of a user key pair or a file key is unknown."),
    INVALID_KEY_ERROR(-5, "A user key pair or a file key is invalid."),
    INTERNAL_ERROR(-6, "A internal error occurred."),
    UNKNOWN_ERROR(-7, "A unknown error occurred.");

    private final int mNumber;
    private final String mText;

    private DracoonCryptoCode(int number, String text) {
        this.mNumber = number;
        this.mText = text;
    }

    public int getNumber() {
        return this.mNumber;
    }

    public String getText() {
        return this.mText;
    }

    public String toString() {
        return this.mNumber + " " + this.mText;
    }

    public static DracoonCryptoCode valueOf(int number) {
        for (DracoonCryptoCode code : DracoonCryptoCode.values()) {
            if (code.mNumber != number) continue;
            return code;
        }
        throw new IllegalArgumentException("No matching constant for [" + number + "]");
    }
}

