/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.filter;

import java.util.ArrayList;
import java.util.List;

public abstract class Filter<TF> {
    private static final String MV_SEPARATOR = ":";
    private static final String MR_SEPARATOR = "|";
    private final String mFieldName;
    private final Type mType;
    private final List<String> mOperators = new ArrayList<String>();
    private final List<TF> mValues = new ArrayList<TF>();

    Filter(String fieldName, Type type) {
        this.mFieldName = fieldName;
        this.mType = type;
    }

    void addValue(String operator, TF value) {
        this.mOperators.add(operator);
        this.mValues.add(value);
    }

    public String toString() {
        switch (this.mType) {
            case MULTI_VALUE: {
                return this.buildMultiValueString();
            }
            case MULTI_RESTRICTION: {
                return this.buildMultiRestrictionString();
            }
        }
        return "";
    }

    private String buildMultiValueString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mFieldName);
        sb.append(MV_SEPARATOR);
        sb.append(this.mOperators.get(0));
        sb.append(MV_SEPARATOR);
        for (int i = 0; i < this.mValues.size(); ++i) {
            sb.append(this.mValues.get(i));
            sb.append(i < this.mValues.size() - 1 ? MV_SEPARATOR : "");
        }
        return sb.toString();
    }

    private String buildMultiRestrictionString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mValues.size(); ++i) {
            sb.append(this.mFieldName);
            sb.append(MV_SEPARATOR);
            sb.append(this.mOperators.get(i));
            sb.append(MV_SEPARATOR);
            sb.append(this.mValues.get(i));
            sb.append(i < this.mValues.size() - 1 ? MR_SEPARATOR : "");
        }
        return sb.toString();
    }

    protected static enum Type {
        MULTI_VALUE,
        MULTI_RESTRICTION;

    }

    protected static abstract class Concater<T1, T2> {
        protected Concater() {
        }

        protected Builder<T1, T2> and() {
            throw new UnsupportedOperationException();
        }

        protected Builder<T1, T2> or() {
            throw new UnsupportedOperationException();
        }

        public abstract Filter<T2> build();
    }

    protected static abstract class Builder<T1, T2> {
        protected static final String OPERATOR_EQ = "eq";
        protected static final String OPERATOR_CN = "cn";
        protected static final String OPERATOR_GE = "ge";
        protected static final String OPERATOR_LE = "le";

        protected Builder() {
        }

        protected Concater<T1, T2> eq(T1 value) {
            throw new UnsupportedOperationException();
        }

        protected Concater<T1, T2> cn(T1 value) {
            throw new UnsupportedOperationException();
        }

        protected Concater<T1, T2> ge(T1 value) {
            throw new UnsupportedOperationException();
        }

        protected Concater<T1, T2> le(T1 value) {
            throw new UnsupportedOperationException();
        }

        protected void validateRestrictionValue(T1 value) {
            if (value == null) {
                throw new IllegalArgumentException("Restriction value cannot be null.");
            }
        }
    }
}

