/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.DracoonAuth;
import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.DracoonHttpConfig;
import com.dracoon.sdk.Log;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.DynamicServiceProxy;
import com.dracoon.sdk.internal.NullLog;
import com.dracoon.sdk.internal.api.DracoonApi;
import com.dracoon.sdk.internal.api.DracoonApiBuilder;
import com.dracoon.sdk.internal.api.DracoonErrorParser;
import com.dracoon.sdk.internal.auth.AuthChecker;
import com.dracoon.sdk.internal.auth.AuthHolder;
import com.dracoon.sdk.internal.auth.AuthInterceptorImpl;
import com.dracoon.sdk.internal.auth.AuthTokenRefresher;
import com.dracoon.sdk.internal.auth.AuthTokenRefresherImpl;
import com.dracoon.sdk.internal.auth.AuthTokenRetriever;
import com.dracoon.sdk.internal.auth.AuthTokenRetrieverImpl;
import com.dracoon.sdk.internal.crypto.CryptoWrapper;
import com.dracoon.sdk.internal.crypto.EncryptionPasswordHolder;
import com.dracoon.sdk.internal.http.HttpClientBuilder;
import com.dracoon.sdk.internal.http.HttpHelper;
import com.dracoon.sdk.internal.oauth.OAuthClient;
import com.dracoon.sdk.internal.service.ServiceDependenciesImpl;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.internal.service.ServiceLocatorImpl;
import java.net.URL;
import okhttp3.OkHttpClient;

public class DracoonClientImpl
extends DracoonClient {
    private final AuthHolder mAuthHolder = new AuthHolder();
    private final EncryptionPasswordHolder mEncPasswordHolder = new EncryptionPasswordHolder();
    private Log mLog = new NullLog();
    private DracoonHttpConfig mHttpConfig = new DracoonHttpConfig();
    private AuthChecker mAuthChecker;
    private AuthTokenRetriever mAuthTokenRetriever;
    private AuthTokenRefresher mAuthTokenRefresher;
    private ServiceLocator mServiceLocator;
    private DynamicServiceProxy mServiceProxy;

    public DracoonClientImpl(URL serverUrl) {
        super(serverUrl);
    }

    @Override
    public DracoonAuth getAuth() {
        return this.mAuthHolder.get();
    }

    public void setAuth(DracoonAuth auth) {
        this.mAuthHolder.set(auth);
    }

    @Override
    public char[] getEncryptionPassword() {
        return this.mEncPasswordHolder.get();
    }

    @Override
    public void setEncryptionPassword(char[] encryptionPassword) {
        this.mEncPasswordHolder.set(encryptionPassword);
    }

    public Log getLog() {
        return this.mLog;
    }

    public void setLog(Log log) {
        this.mLog = log != null ? log : new NullLog();
    }

    public DracoonHttpConfig getHttpConfig() {
        return this.mHttpConfig;
    }

    public void setHttpConfig(DracoonHttpConfig httpConfig) {
        this.mHttpConfig = httpConfig != null ? httpConfig : new DracoonHttpConfig();
    }

    public void init() {
        this.initAuthHelpers();
        this.initServiceLocator();
        this.initServiceProxy();
    }

    private void initAuthHelpers() {
        OAuthClient oAuthClient = new OAuthClient(this.mServerUrl);
        oAuthClient.setLog(this.mLog);
        oAuthClient.setHttpConfig(this.mHttpConfig);
        oAuthClient.init();
        this.mAuthChecker = new AuthChecker(() -> this.mServiceLocator.getAccountService().pingUser());
        this.mAuthTokenRetriever = new AuthTokenRetrieverImpl(oAuthClient, this.mAuthHolder);
        this.mAuthTokenRefresher = new AuthTokenRefresherImpl(oAuthClient, this.mAuthHolder);
    }

    private void initServiceLocator() {
        OkHttpClient httpClient = new HttpClientBuilder().build(this.mHttpConfig);
        HttpHelper httpHelper = new HttpHelper();
        httpHelper.setLog(this.mLog);
        httpHelper.setRetryEnabled(this.mHttpConfig.isRetryEnabled());
        httpHelper.setRateLimitingEnabled(this.mHttpConfig.isRateLimitingEnabled());
        httpHelper.init();
        AuthInterceptorImpl authInterceptor = new AuthInterceptorImpl(this.mAuthHolder, this.mAuthTokenRefresher);
        DracoonApi dracoonApi = new DracoonApiBuilder().build(this.mServerUrl, httpClient, authInterceptor);
        DracoonErrorParser dracoonErrorParser = new DracoonErrorParser();
        dracoonErrorParser.setLog(this.mLog);
        CryptoWrapper cryptoWrapper = new CryptoWrapper(this.mLog);
        ServiceDependenciesImpl serviceDependencies = new ServiceDependenciesImpl.Builder().setLog(this.mLog).setHttpConfig(this.mHttpConfig).setHttpClient(httpClient).setHttpHelper(httpHelper).setServerUrl(this.mServerUrl).setDracoonApi(dracoonApi).setDracoonErrorParser(dracoonErrorParser).setEncryptionPasswordHolder(this.mEncPasswordHolder).setCryptoWrapper(cryptoWrapper).build();
        this.mServiceLocator = new ServiceLocatorImpl(serviceDependencies);
    }

    private void initServiceProxy() {
        this.mServiceProxy = new DynamicServiceProxy(this.mServiceLocator);
        this.mServiceProxy.prepare();
    }

    public void checkApiVersionSupported() throws DracoonNetIOException, DracoonApiException {
        this.mServiceLocator.getServerInfoService().checkVersionSupported();
    }

    public void retrieveAuthTokens() throws DracoonApiException, DracoonNetIOException {
        this.mAuthTokenRetriever.retrieve();
    }

    @Override
    public boolean isAuthValid() throws DracoonNetIOException, DracoonApiException {
        return this.mAuthChecker.isAuthValid();
    }

    @Override
    public void checkAuthValid() throws DracoonNetIOException, DracoonApiException {
        this.mAuthChecker.checkAuthValid();
    }

    @Override
    public DracoonClient.Server server() {
        return this.mServiceProxy.server();
    }

    @Override
    public DracoonClient.Account account() {
        return this.mServiceProxy.account();
    }

    @Override
    public DracoonClient.Users users() {
        return this.mServiceProxy.users();
    }

    @Override
    public DracoonClient.Groups groups() {
        return this.mServiceProxy.groups();
    }

    @Override
    public DracoonClient.Nodes nodes() {
        return this.mServiceProxy.nodes();
    }

    @Override
    public DracoonClient.Shares shares() {
        return this.mServiceProxy.shares();
    }
}

