/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.internal.ClientImpl;
import com.dracoon.sdk.internal.ClientMethodImpl;
import com.dracoon.sdk.internal.service.Service;
import com.dracoon.sdk.internal.service.ServiceLocator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class DynamicServiceProxy {
    private final List<Service> mServices = new ArrayList<Service>();
    private final Map<Class<?>, Object> mServiceProxies = new HashMap();

    DynamicServiceProxy(ServiceLocator servicelocator) {
        this.init(servicelocator);
    }

    private void init(ServiceLocator serviceLocator) {
        this.mServices.add(new ServerGroupsService());
        this.mServices.addAll(serviceLocator.getServices());
    }

    public void prepare() {
        this.createProxy(DracoonClient.Server.class);
        this.createProxy(DracoonClient.ServerSettings.class);
        this.createProxy(DracoonClient.ServerPolicies.class);
        this.createProxy(DracoonClient.ServerPolicies.class);
        this.createProxy(DracoonClient.Account.class);
        this.createProxy(DracoonClient.Users.class);
        this.createProxy(DracoonClient.Groups.class);
        this.createProxy(DracoonClient.Nodes.class);
        this.createProxy(DracoonClient.Shares.class);
    }

    public DracoonClient.Server server() {
        return this.findProxy(DracoonClient.Server.class);
    }

    public DracoonClient.Account account() {
        return this.findProxy(DracoonClient.Account.class);
    }

    public DracoonClient.Users users() {
        return this.findProxy(DracoonClient.Users.class);
    }

    public DracoonClient.Groups groups() {
        return this.findProxy(DracoonClient.Groups.class);
    }

    public DracoonClient.Nodes nodes() {
        return this.findProxy(DracoonClient.Nodes.class);
    }

    public DracoonClient.Shares shares() {
        return this.findProxy(DracoonClient.Shares.class);
    }

    private <T> void createProxy(Class<T> i) {
        T proxy = DynamicServiceProxy.createProxy(i, this.mServices);
        this.mServiceProxies.put(i, proxy);
    }

    private <T> T findProxy(Class<T> i) {
        Object proxy = this.mServiceProxies.get(i);
        if (proxy == null) {
            throw new RuntimeException(String.format("Could not find proxy for: %s", i.getName()));
        }
        return (T)proxy;
    }

    private static <I> I createProxy(Class<I> i, List<Service> services) {
        return (I)Proxy.newProxyInstance(i.getClassLoader(), new Class[]{i}, (InvocationHandler)new ProxyHandler(i, services));
    }

    @ClientImpl(value=DracoonClient.Server.class)
    private class ServerGroupsService
    implements Service {
        private ServerGroupsService() {
        }

        @ClientMethodImpl
        public DracoonClient.ServerSettings settings() {
            return DynamicServiceProxy.this.findProxy(DracoonClient.ServerSettings.class);
        }

        @ClientMethodImpl
        public DracoonClient.ServerPolicies policies() {
            return DynamicServiceProxy.this.findProxy(DracoonClient.ServerPolicies.class);
        }
    }

    private static class ProxyHandler
    implements InvocationHandler {
        private final Map<Method, ProxyTarget> mTargetMethodCache = new HashMap<Method, ProxyTarget>();

        ProxyHandler(Class<?> clazz, List<Service> services) {
            this.init(clazz, services);
        }

        private void init(Class<?> clazz, List<Service> services) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                ProxyTarget proxyTarget = this.findProxyTarget(clazz, method, services);
                this.mTargetMethodCache.put(method, proxyTarget);
            }
        }

        private ProxyTarget findProxyTarget(Class<?> clazz, Method method, List<Service> services) {
            for (Service service : services) {
                ProxyTarget proxyTarget;
                ClientImpl clientImplAnnotation = service.getClass().getAnnotation(ClientImpl.class);
                if (clientImplAnnotation == null || clientImplAnnotation.value() != clazz || (proxyTarget = this.findProxyTarget(method, service)) == null) continue;
                return proxyTarget;
            }
            throw new RuntimeException(String.format("Could not proxy method call for: %s/%s", clazz, method.getName()));
        }

        private ProxyTarget findProxyTarget(Method method, Service service) {
            Method serviceMethod;
            Method[] serviceMethods;
            ProxyTarget proxyTarget = null;
            Method[] methodArray = serviceMethods = service.getClass().getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n && (proxyTarget = this.findProxyTarget(method, service, serviceMethod = methodArray[i])) == null; ++i) {
            }
            return proxyTarget;
        }

        private ProxyTarget findProxyTarget(Method method, Service service, Method serviceMethod) {
            if (!Modifier.isPublic(serviceMethod.getModifiers())) {
                return null;
            }
            ClientMethodImpl clientMethodImplAnnotation = serviceMethod.getAnnotation(ClientMethodImpl.class);
            if (clientMethodImplAnnotation == null) {
                return null;
            }
            String serviceMethodName = clientMethodImplAnnotation.value();
            if (serviceMethodName.isEmpty()) {
                serviceMethodName = serviceMethod.getName();
            }
            if (!Objects.equals(serviceMethodName, method.getName())) {
                return null;
            }
            if (!Arrays.equals(serviceMethod.getParameterTypes(), method.getParameterTypes())) {
                return null;
            }
            if (!Objects.equals(serviceMethod.getReturnType(), method.getReturnType())) {
                return null;
            }
            return new ProxyTarget(service, serviceMethod);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ProxyTarget target = this.mTargetMethodCache.get(method);
            if (target == null) {
                throw new RuntimeException(String.format("Could not proxy method call for: %s/%s", method.getDeclaringClass(), method.getName()));
            }
            try {
                return target.getMethod().invoke((Object)target.getService(), args);
            }
            catch (Exception e) {
                throw e.getCause();
            }
        }
    }

    private static class ProxyTarget {
        private final Service mService;
        private final Method mMethod;

        ProxyTarget(Service service, Method method) {
            this.mService = service;
            this.mMethod = method;
        }

        public Service getService() {
            return this.mService;
        }

        public Method getMethod() {
            return this.mMethod;
        }
    }
}

