/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.api;

import com.dracoon.sdk.internal.api.model.ApiCompleteFileUploadRequest;
import com.dracoon.sdk.internal.api.model.ApiCompleteS3FileUploadRequest;
import com.dracoon.sdk.internal.api.model.ApiCopyNodesRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateDownloadShareRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateFileUploadRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateFolderRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateNodeCommentRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateRoomRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateUploadShareRequest;
import com.dracoon.sdk.internal.api.model.ApiCustomerAccount;
import com.dracoon.sdk.internal.api.model.ApiDeleteNodesRequest;
import com.dracoon.sdk.internal.api.model.ApiDownloadShare;
import com.dracoon.sdk.internal.api.model.ApiDownloadShareList;
import com.dracoon.sdk.internal.api.model.ApiDownloadToken;
import com.dracoon.sdk.internal.api.model.ApiFileKey;
import com.dracoon.sdk.internal.api.model.ApiFileUpload;
import com.dracoon.sdk.internal.api.model.ApiGetNodesVirusProtectionInfoRequest;
import com.dracoon.sdk.internal.api.model.ApiGetS3FileUploadUrlsRequest;
import com.dracoon.sdk.internal.api.model.ApiMissingFileKeys;
import com.dracoon.sdk.internal.api.model.ApiMoveNodesRequest;
import com.dracoon.sdk.internal.api.model.ApiNode;
import com.dracoon.sdk.internal.api.model.ApiNodeComment;
import com.dracoon.sdk.internal.api.model.ApiNodeCommentList;
import com.dracoon.sdk.internal.api.model.ApiNodeList;
import com.dracoon.sdk.internal.api.model.ApiNodeVirusProtectionInfo;
import com.dracoon.sdk.internal.api.model.ApiS3FileUploadStatus;
import com.dracoon.sdk.internal.api.model.ApiS3FileUploadUrlList;
import com.dracoon.sdk.internal.api.model.ApiServerClassificationPolicies;
import com.dracoon.sdk.internal.api.model.ApiServerCryptoAlgorithms;
import com.dracoon.sdk.internal.api.model.ApiServerDefaults;
import com.dracoon.sdk.internal.api.model.ApiServerGeneralSettings;
import com.dracoon.sdk.internal.api.model.ApiServerInfo;
import com.dracoon.sdk.internal.api.model.ApiServerPasswordPolicies;
import com.dracoon.sdk.internal.api.model.ApiServerTime;
import com.dracoon.sdk.internal.api.model.ApiSetFileKeysRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateFileRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateFolderRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateNodeCommentRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateRoomConfigRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateRoomRequest;
import com.dracoon.sdk.internal.api.model.ApiUploadShare;
import com.dracoon.sdk.internal.api.model.ApiUploadShareList;
import com.dracoon.sdk.internal.api.model.ApiUserAccount;
import com.dracoon.sdk.internal.api.model.ApiUserAvatarInfo;
import com.dracoon.sdk.internal.api.model.ApiUserKeyPair;
import com.dracoon.sdk.internal.api.model.ApiUserProfileAttributes;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface DracoonApi {
    @GET(value="/api/v4/public/software/version")
    public Call<ApiServerInfo> getServerInfo();

    @GET(value="/api/v4/public/time")
    public Call<ApiServerTime> getServerTime();

    @GET(value="/api/v4/config/info/general")
    public Call<ApiServerGeneralSettings> getServerGeneralSettings();

    @GET(value="/api/v4/config/info/defaults")
    public Call<ApiServerDefaults> getServerDefaults();

    @GET(value="/api/v4/config/info/policies/algorithms")
    public Call<ApiServerCryptoAlgorithms> getServerCryptoAlgorithms();

    @GET(value="/api/v4/config/info/policies/passwords")
    public Call<ApiServerPasswordPolicies> getServerPasswordPolicies();

    @GET(value="/api/v4/config/info/policies/classifications")
    public Call<ApiServerClassificationPolicies> getServerClassificationPolicies();

    @GET(value="/api/v4/user/ping")
    public Call<Void> pingUser();

    @GET(value="/api/v4/user/account")
    public Call<ApiUserAccount> getUserAccount();

    @GET(value="/api/v4/user/account/customer")
    public Call<ApiCustomerAccount> getCustomerAccount();

    @GET(value="/api/v4/user/account/keypairs")
    public Call<List<ApiUserKeyPair>> getUserKeyPairs();

    @POST(value="/api/v4/user/account/keypair")
    public Call<Void> setUserKeyPair(@Body ApiUserKeyPair var1);

    @GET(value="/api/v4/user/account/keypair")
    public Call<ApiUserKeyPair> getUserKeyPair(@Query(value="version") String var1);

    @DELETE(value="/api/v4/user/account/keypair")
    public Call<Void> deleteUserKeyPair(@Query(value="version") String var1);

    @PUT(value="/api/v4/user/profileAttributes")
    public Call<Void> setUserProfileAttributes(@Body ApiUserProfileAttributes var1);

    @GET(value="/api/v4/user/profileAttributes")
    public Call<ApiUserProfileAttributes> getUserProfileAttributes();

    @DELETE(value="/api/v4/user/profileAttributes/{key}")
    public Call<Void> deleteUserProfileAttribute(@Path(value="key") String var1);

    @GET(value="/api/v4/user/account/avatar")
    public Call<ApiUserAvatarInfo> getUserAvatarInfo();

    @POST(value="/api/v4/user/account/avatar")
    public Call<Void> setUserAvatar(@Body RequestBody var1);

    @DELETE(value="/api/v4/user/account/avatar")
    public Call<Void> deleteUserAvatar();

    @GET(value="/api/v4/nodes")
    public Call<ApiNodeList> getNodes(@Query(value="parent_id") Long var1, @Query(value="depth_level") Integer var2, @Query(value="filter") String var3, @Query(value="sort") String var4, @Query(value="offset") Long var5, @Query(value="limit") Long var6);

    @GET(value="/api/v4/nodes/{node_id}")
    public Call<ApiNode> getNode(@Path(value="node_id") Long var1);

    @GET(value="/api/v4/nodes/search")
    public Call<ApiNodeList> searchNodes(@Query(value="search_string") String var1, @Query(value="parent_id") Long var2, @Query(value="depth_level") Integer var3, @Query(value="filter") String var4, @Query(value="sort") String var5, @Query(value="offset") Long var6, @Query(value="limit") Long var7);

    @POST(value="/api/v4/nodes/rooms")
    public Call<ApiNode> createRoom(@Body ApiCreateRoomRequest var1);

    @PUT(value="/api/v4/nodes/rooms/{room_id}")
    public Call<ApiNode> updateRoom(@Path(value="room_id") Long var1, @Body ApiUpdateRoomRequest var2);

    @PUT(value="/api/v4/nodes/rooms/{room_id}/config")
    public Call<ApiNode> updateRoomConfig(@Path(value="room_id") Long var1, @Body ApiUpdateRoomConfigRequest var2);

    @POST(value="/api/v4/nodes/folders")
    public Call<ApiNode> createFolder(@Body ApiCreateFolderRequest var1);

    @PUT(value="/api/v4/nodes/folders/{folder_id}")
    public Call<ApiNode> updateFolder(@Path(value="folder_id") Long var1, @Body ApiUpdateFolderRequest var2);

    @PUT(value="/api/v4/nodes/files/{file_id}")
    public Call<ApiNode> updateFile(@Path(value="file_id") Long var1, @Body ApiUpdateFileRequest var2);

    @HTTP(method="DELETE", hasBody=true, path="/api/v4/nodes")
    public Call<Void> deleteNodes(@Body ApiDeleteNodesRequest var1);

    @DELETE(value="/api/v4/nodes/{node_id}")
    public Call<Void> deleteNode(@Path(value="node_id") Long var1);

    @POST(value="/api/v4/nodes/{node_id}/copy_to")
    public Call<ApiNode> copyNodes(@Path(value="node_id") Long var1, @Body ApiCopyNodesRequest var2);

    @POST(value="/api/v4/nodes/{node_id}/move_to")
    public Call<ApiNode> moveNodes(@Path(value="node_id") Long var1, @Body ApiMoveNodesRequest var2);

    @POST(value="/api/v4/nodes/files/uploads")
    public Call<ApiFileUpload> createFileUpload(@Body ApiCreateFileUploadRequest var1);

    @Multipart
    @POST(value="/api/v4/nodes/files/uploads/{upload_id}")
    public Call<Void> uploadFile(@Path(value="upload_id") String var1, @Header(value="Content-Range") String var2, @Part MultipartBody.Part var3);

    @PUT(value="/api/v4/nodes/files/uploads/{upload_id}")
    public Call<ApiNode> completeFileUpload(@Path(value="upload_id") String var1, @Body ApiCompleteFileUploadRequest var2);

    @POST(value="/api/v4/nodes/files/uploads/{upload_id}/s3_urls")
    public Call<ApiS3FileUploadUrlList> getS3FileUploadUrls(@Path(value="upload_id") String var1, @Body ApiGetS3FileUploadUrlsRequest var2);

    @PUT(value="/api/v4/nodes/files/uploads/{upload_id}/s3")
    public Call<Void> completeS3FileUpload(@Path(value="upload_id") String var1, @Body ApiCompleteS3FileUploadRequest var2);

    @GET(value="/api/v4/nodes/files/uploads/{upload_id}")
    public Call<ApiS3FileUploadStatus> getS3FileUploadStatus(@Path(value="upload_id") String var1);

    @POST(value="/api/v4/nodes/files/{file_id}/downloads")
    public Call<ApiDownloadToken> getDownloadToken(@Path(value="file_id") Long var1);

    @GET(value="/api/v4/nodes/files/{file_id}/user_file_key")
    public Call<ApiFileKey> getFileKey(@Path(value="file_id") Long var1);

    @GET(value="/api/v4/nodes/missingFileKeys")
    public Call<ApiMissingFileKeys> getMissingFileKeys(@Query(value="file_id") Long var1, @Query(value="offset") Long var2, @Query(value="limit") Long var3);

    @POST(value="/api/v4/nodes/files/keys")
    public Call<Void> setFileKeys(@Body ApiSetFileKeysRequest var1);

    @POST(value="/api/v4/nodes/{node_id}/favorite")
    public Call<Void> markFavorite(@Path(value="node_id") Long var1);

    @DELETE(value="/api/v4/nodes/{node_id}/favorite")
    public Call<Void> unmarkFavorite(@Path(value="node_id") Long var1);

    @GET(value="/api/v4/nodes/{node_id}/comments")
    public Call<ApiNodeCommentList> getNodeComments(@Path(value="node_id") Long var1, @Query(value="offset") Long var2, @Query(value="limit") Long var3);

    @POST(value="/api/v4/nodes/{node_id}/comments")
    public Call<ApiNodeComment> createNodeComment(@Path(value="node_id") Long var1, @Body ApiCreateNodeCommentRequest var2);

    @PUT(value="/api/v4/nodes/comments/{comment_id}")
    public Call<ApiNodeComment> updateNodeComment(@Path(value="comment_id") Long var1, @Body ApiUpdateNodeCommentRequest var2);

    @DELETE(value="/api/v4/nodes/comments/{comment_id}")
    public Call<Void> deleteNodeComment(@Path(value="comment_id") Long var1);

    @POST(value="/api/v4/nodes/files/generate_verdict_info")
    public Call<List<ApiNodeVirusProtectionInfo>> getNodesVirusProtectionInfo(@Body ApiGetNodesVirusProtectionInfoRequest var1);

    @DELETE(value="/api/v4/nodes/malicious_files/{malicious_file_id}")
    public Call<Void> deleteMaliciousFile(@Path(value="malicious_file_id") Long var1);

    @POST(value="/api/v4/shares/downloads")
    public Call<ApiDownloadShare> createDownloadShare(@Body ApiCreateDownloadShareRequest var1);

    @GET(value="/api/v4/shares/downloads")
    public Call<ApiDownloadShareList> getDownloadShares(@Query(value="filter") String var1, @Query(value="offset") Long var2, @Query(value="limit") Long var3);

    @GET(value="/api/v4/shares/downloads/{share_id}/qr")
    public Call<ApiDownloadShare> getDownloadShareQR(@Path(value="share_id") Long var1);

    @DELETE(value="/api/v4/shares/downloads/{share_id}")
    public Call<Void> deleteDownloadShare(@Path(value="share_id") Long var1);

    @POST(value="/api/v4/shares/uploads")
    public Call<ApiUploadShare> createUploadShare(@Body ApiCreateUploadShareRequest var1);

    @GET(value="/api/v4/shares/uploads")
    public Call<ApiUploadShareList> getUploadShares(@Query(value="filter") String var1, @Query(value="offset") Long var2, @Query(value="limit") Long var3);

    @GET(value="/api/v4/shares/uploads/{share_id}/qr")
    public Call<ApiUploadShare> getUploadShareQR(@Path(value="share_id") Long var1);

    @DELETE(value="/api/v4/shares/uploads/{share_id}")
    public Call<Void> deleteUploadShare(@Path(value="share_id") Long var1);
}

