/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.api.mapper;

import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.dracoon.sdk.internal.api.mapper.BaseMapper;
import com.dracoon.sdk.internal.api.model.ApiUserAccount;
import com.dracoon.sdk.internal.api.model.ApiUserAvatarInfo;
import com.dracoon.sdk.internal.api.model.ApiUserInfo;
import com.dracoon.sdk.internal.api.model.ApiUserKeyPair;
import com.dracoon.sdk.internal.api.model.ApiUserPrivateKey;
import com.dracoon.sdk.internal.api.model.ApiUserPublicKey;
import com.dracoon.sdk.internal.api.model.ApiUserRole;
import com.dracoon.sdk.model.Gender;
import com.dracoon.sdk.model.UserAccount;
import com.dracoon.sdk.model.UserInfo;
import com.dracoon.sdk.model.UserRole;
import java.util.ArrayList;
import java.util.UUID;

public class UserMapper
extends BaseMapper {
    private UserMapper() {
    }

    public static UserInfo fromApiUserInfo(ApiUserInfo apiUserInfo) {
        if (apiUserInfo == null) {
            return null;
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(apiUserInfo.id);
        userInfo.setUserType(UserInfo.UserType.getByValue(apiUserInfo.userType));
        userInfo.setFirstName(apiUserInfo.firstName);
        userInfo.setLastName(apiUserInfo.lastName);
        userInfo.setUsername(apiUserInfo.userName);
        userInfo.setEmail(apiUserInfo.email);
        try {
            userInfo.setAvatarUuid(UUID.fromString(apiUserInfo.avatarUuid));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return userInfo;
    }

    public static UserAccount fromApiUserAccount(ApiUserAccount apiUserAccount, ApiUserAvatarInfo apiUserAvatarInfo) {
        if (apiUserAccount == null) {
            return null;
        }
        UserAccount userAccount = new UserAccount();
        userAccount.setId(apiUserAccount.id);
        userAccount.setTitle(apiUserAccount.title);
        userAccount.setGender(Gender.getByValue(apiUserAccount.gender));
        userAccount.setFirstName(apiUserAccount.firstName);
        userAccount.setLastName(apiUserAccount.lastName);
        userAccount.setEmail(apiUserAccount.email);
        userAccount.setUsername(apiUserAccount.userName != null ? apiUserAccount.userName : apiUserAccount.login);
        userAccount.setHasEncryptionEnabled(UserMapper.toBoolean(apiUserAccount.isEncryptionEnabled));
        userAccount.setHasManageableRooms(UserMapper.toBoolean(apiUserAccount.hasManageableRooms));
        userAccount.setNeedsToAcceptEULA(UserMapper.toBoolean(apiUserAccount.needsToAcceptEULA));
        userAccount.setNeedsToChangeUserName(UserMapper.toBoolean(apiUserAccount.needsToChangeUserName));
        userAccount.setNeedsToChangePassword(UserMapper.toBoolean(apiUserAccount.needsToChangePassword));
        userAccount.setExpireAt(apiUserAccount.expireAt);
        userAccount.setLastLoginSuccessAt(apiUserAccount.lastLoginSuccessAt);
        userAccount.setLastLoginSuccessIp(apiUserAccount.lastLoginSuccessIp);
        userAccount.setLastLoginFailAt(apiUserAccount.lastLoginFailAt);
        userAccount.setLastLoginFailIp(apiUserAccount.lastLoginFailIp);
        ArrayList<UserRole> userRoles = new ArrayList<UserRole>();
        if (apiUserAccount.userRoles != null) {
            for (ApiUserRole apiUserRole : apiUserAccount.userRoles.items) {
                userRoles.add(UserMapper.fromApiUserRole(apiUserRole));
            }
        }
        userAccount.setUserRoles(userRoles);
        if (apiUserAvatarInfo != null) {
            try {
                userAccount.setAvatarUuid(UUID.fromString(apiUserAvatarInfo.avatarUuid));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            userAccount.setHasCustomAvatar(apiUserAvatarInfo.isCustomAvatar);
        }
        return userAccount;
    }

    private static UserRole fromApiUserRole(ApiUserRole apiUserRole) {
        if (apiUserRole == null) {
            return null;
        }
        return UserRole.getByValue(apiUserRole.id);
    }

    public static ApiUserKeyPair toApiUserKeyPair(UserKeyPair userKeyPair) {
        if (userKeyPair == null) {
            return null;
        }
        ApiUserKeyPair apiUserKeyPair = new ApiUserKeyPair();
        apiUserKeyPair.privateKeyContainer = UserMapper.toApiUserPrivateKey(userKeyPair.getUserPrivateKey());
        apiUserKeyPair.publicKeyContainer = UserMapper.toApiUserPublicKey(userKeyPair.getUserPublicKey());
        return apiUserKeyPair;
    }

    private static ApiUserPrivateKey toApiUserPrivateKey(UserPrivateKey userPrivateKey) {
        if (userPrivateKey == null) {
            return null;
        }
        ApiUserPrivateKey apiUserPrivateKey = new ApiUserPrivateKey();
        apiUserPrivateKey.version = userPrivateKey.getVersion().getValue();
        apiUserPrivateKey.privateKey = userPrivateKey.getPrivateKey();
        return apiUserPrivateKey;
    }

    private static ApiUserPublicKey toApiUserPublicKey(UserPublicKey userPublicKey) {
        if (userPublicKey == null) {
            return null;
        }
        ApiUserPublicKey apiUserPublicKey = new ApiUserPublicKey();
        apiUserPublicKey.version = userPublicKey.getVersion().getValue();
        apiUserPublicKey.publicKey = userPublicKey.getPublicKey();
        return apiUserPublicKey;
    }

    public static UserKeyPair fromApiUserKeyPair(ApiUserKeyPair apiUserKeyPair) throws UnknownVersionException {
        if (apiUserKeyPair == null) {
            return null;
        }
        return new UserKeyPair(UserMapper.fromApiUserPrivateKey(apiUserKeyPair.privateKeyContainer), UserMapper.fromApiUserPublicKey(apiUserKeyPair.publicKeyContainer));
    }

    private static UserPrivateKey fromApiUserPrivateKey(ApiUserPrivateKey apiUserPrivateKey) throws UnknownVersionException {
        if (apiUserPrivateKey == null) {
            return null;
        }
        UserKeyPair.Version version = UserKeyPair.Version.getByValue((String)apiUserPrivateKey.version);
        return new UserPrivateKey(version, apiUserPrivateKey.privateKey);
    }

    public static UserPublicKey fromApiUserPublicKey(ApiUserPublicKey apiUserPublicKey) throws UnknownVersionException {
        if (apiUserPublicKey == null) {
            return null;
        }
        UserKeyPair.Version version = UserKeyPair.Version.getByValue((String)apiUserPublicKey.version);
        return new UserPublicKey(version, apiUserPublicKey.publicKey);
    }
}

