/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.auth;

import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;

public class AuthChecker {
    private final CheckCall mCheckCall;

    public AuthChecker(CheckCall checkCall) {
        this.mCheckCall = checkCall;
    }

    public boolean isAuthValid() throws DracoonNetIOException, DracoonApiException {
        try {
            this.mCheckCall.execute();
        }
        catch (DracoonApiException e) {
            if (e.getCode().isAuthError()) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public void checkAuthValid() throws DracoonNetIOException, DracoonApiException {
        this.mCheckCall.execute();
    }

    public static interface CheckCall {
        public void execute() throws DracoonNetIOException, DracoonApiException;
    }
}

