/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.auth;

import com.dracoon.sdk.DracoonAuth;
import com.dracoon.sdk.internal.auth.AuthHolder;
import com.dracoon.sdk.internal.auth.AuthInterceptor;
import com.dracoon.sdk.internal.auth.AuthTokenRefresher;
import com.dracoon.sdk.internal.http.HttpStatus;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class AuthInterceptorImpl
implements AuthInterceptor {
    private final AuthHolder mAuthHolder;
    private final AuthTokenRefresher mAuthTokenRefresher;

    public AuthInterceptorImpl(AuthHolder authHolder, AuthTokenRefresher authTokenRefresher) {
        this.mAuthHolder = authHolder;
        this.mAuthTokenRefresher = authTokenRefresher;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.isPublicRequest(request)) {
            return chain.proceed(request);
        }
        if (!this.hasAccessToken()) {
            return chain.proceed(request);
        }
        Response response = chain.proceed(this.addAuthorizationHeader(request));
        if (this.isSuccessfulResponse(response)) {
            return response;
        }
        if (!this.hasRefreshToken()) {
            return response;
        }
        response.close();
        this.mAuthTokenRefresher.refresh();
        return chain.proceed(this.addAuthorizationHeader(request));
    }

    private boolean isPublicRequest(Request request) {
        return request.url().encodedPath().startsWith("/api/v4/public/");
    }

    private boolean hasAccessToken() {
        DracoonAuth auth = this.mAuthHolder.get();
        return auth != null && auth.getAccessToken() != null;
    }

    private boolean hasRefreshToken() {
        DracoonAuth auth = this.mAuthHolder.get();
        return auth != null && auth.getRefreshToken() != null;
    }

    private boolean isSuccessfulResponse(Response response) {
        return response.code() != HttpStatus.UNAUTHORIZED.getNumber();
    }

    private Request addAuthorizationHeader(Request request) {
        DracoonAuth auth = this.mAuthHolder.get();
        return request.newBuilder().header("Authorization", "Bearer " + auth.getAccessToken()).build();
    }
}

