/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.auth;

import com.dracoon.sdk.DracoonAuth;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.auth.AuthHolder;
import com.dracoon.sdk.internal.auth.AuthTokenRefresher;
import com.dracoon.sdk.internal.http.InterceptedIOException;
import com.dracoon.sdk.internal.oauth.OAuthClient;
import com.dracoon.sdk.internal.oauth.OAuthTokens;
import java.io.IOException;

public class AuthTokenRefresherImpl
implements AuthTokenRefresher {
    private static final long AUTH_REFRESH_SKIP_INTERVAL = 15000L;
    private final OAuthClient mOAuthClient;
    private final AuthHolder mAuthHolder;
    private long mLastRefreshTime = 0L;
    private InterceptedIOException mLastRefreshException = null;

    public AuthTokenRefresherImpl(OAuthClient oAuthClient, AuthHolder authHolder) {
        this.mOAuthClient = oAuthClient;
        this.mAuthHolder = authHolder;
    }

    void setLastRefreshTime(long lastRefreshTime) {
        this.mLastRefreshTime = lastRefreshTime;
    }

    @Override
    public synchronized void refresh() throws IOException {
        DracoonAuth auth = this.mAuthHolder.get();
        if (auth == null) {
            return;
        }
        DracoonAuth newAuth = this.refresh(auth);
        if (newAuth != auth) {
            this.mAuthHolder.set(newAuth);
        }
    }

    private DracoonAuth refresh(DracoonAuth auth) throws IOException {
        OAuthTokens tokens;
        if (this.mLastRefreshTime + 15000L > System.currentTimeMillis()) {
            if (this.mLastRefreshException != null) {
                throw this.mLastRefreshException;
            }
            return auth;
        }
        try {
            tokens = this.mOAuthClient.refreshTokens(auth.getClientId(), auth.getClientSecret(), auth.getRefreshToken());
            this.mLastRefreshTime = System.currentTimeMillis();
            this.mLastRefreshException = null;
        }
        catch (DracoonNetIOException e) {
            throw new InterceptedIOException(e);
        }
        catch (DracoonApiException e) {
            this.mLastRefreshTime = System.currentTimeMillis();
            this.mLastRefreshException = new InterceptedIOException(e);
            throw this.mLastRefreshException;
        }
        return new DracoonAuth(auth.getClientId(), auth.getClientSecret(), tokens.accessToken, tokens.refreshToken);
    }
}

