/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.auth;

import com.dracoon.sdk.DracoonAuth;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.auth.AuthHolder;
import com.dracoon.sdk.internal.auth.AuthTokenRetriever;
import com.dracoon.sdk.internal.oauth.OAuthClient;
import com.dracoon.sdk.internal.oauth.OAuthTokens;

public class AuthTokenRetrieverImpl
implements AuthTokenRetriever {
    private final OAuthClient mOAuthClient;
    private final AuthHolder mAuthHolder;

    public AuthTokenRetrieverImpl(OAuthClient oAuthClient, AuthHolder authHolder) {
        this.mOAuthClient = oAuthClient;
        this.mAuthHolder = authHolder;
    }

    @Override
    public synchronized void retrieve() throws DracoonApiException, DracoonNetIOException {
        DracoonAuth auth = this.mAuthHolder.get();
        if (auth == null || !auth.getMode().equals((Object)DracoonAuth.Mode.AUTHORIZATION_CODE)) {
            return;
        }
        OAuthTokens tokens = this.mOAuthClient.retrieveTokens(auth.getClientId(), auth.getClientSecret(), auth.getAuthorizationCode());
        auth = new DracoonAuth(auth.getClientId(), auth.getClientSecret(), tokens.accessToken, tokens.refreshToken);
        this.mAuthHolder.set(auth);
    }
}

