/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.http;

import com.dracoon.sdk.DracoonHttpConfig;
import com.dracoon.sdk.internal.http.BufferedSocketFactory;
import com.dracoon.sdk.internal.http.UserAgentInterceptor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class HttpClientBuilder {
    private static final int HTTP_SOCKET_BUFFER_SIZE = 16384;

    public OkHttpClient build(DracoonHttpConfig httpConfig) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)httpConfig.getConnectTimeout(), TimeUnit.SECONDS);
        builder.readTimeout((long)httpConfig.getReadTimeout(), TimeUnit.SECONDS);
        builder.writeTimeout((long)httpConfig.getWriteTimeout(), TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(true);
        builder.socketFactory((SocketFactory)new BufferedSocketFactory(16384));
        if (httpConfig.isProxyEnabled()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpConfig.getProxyAddress(), (int)httpConfig.getProxyPort()));
            builder.proxy(proxy);
        }
        for (Interceptor interceptor : httpConfig.getOkHttpApplicationInterceptors()) {
            builder.addInterceptor(interceptor);
        }
        builder.addNetworkInterceptor((Interceptor)new UserAgentInterceptor(httpConfig.getUserAgent()));
        for (Interceptor interceptor : httpConfig.getOkHttpNetworkInterceptors()) {
            builder.addNetworkInterceptor(interceptor);
        }
        return builder.build();
    }
}

