/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.api.DracoonErrorParser;
import com.dracoon.sdk.internal.http.HttpHelper;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AvatarDownloader {
    private static final String LOG_TAG = AvatarDownloader.class.getSimpleName();
    private final Log mLog;
    private final OkHttpClient mHttpClient;
    private final HttpHelper mHttpHelper;
    private final DracoonErrorParser mErrorParser;

    public AvatarDownloader(Log log, OkHttpClient httpClient, HttpHelper httpHelper, DracoonErrorParser errorParser) {
        this.mLog = log;
        this.mHttpClient = httpClient;
        this.mHttpHelper = httpHelper;
        this.mErrorParser = errorParser;
    }

    public byte[] downloadAvatar(String downloadUrl) throws DracoonNetIOException, DracoonApiException {
        Request request = new Request.Builder().url(downloadUrl).build();
        Call call = this.mHttpClient.newCall(request);
        Response response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseAvatarDownloadError(response);
            String errorText = String.format("Download of avatar with URL '%s' failed with '%s'!", downloadUrl, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        try {
            return response.body().bytes();
        }
        catch (IOException e) {
            String errorText = "Server communication failed!";
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonNetIOException(errorText, e);
        }
    }
}

