/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.internal.api.DracoonApi;
import com.dracoon.sdk.internal.api.DracoonErrorParser;
import com.dracoon.sdk.internal.crypto.CryptoWrapper;
import com.dracoon.sdk.internal.crypto.EncryptionPasswordHolder;
import com.dracoon.sdk.internal.http.HttpHelper;
import com.dracoon.sdk.internal.service.FileStreamHelper;
import com.dracoon.sdk.internal.service.Service;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.internal.service.ThreadHelper;
import java.net.URL;

public abstract class BaseService
implements Service {
    protected final ServiceLocator mServiceLocator;
    protected final Log mLog;
    protected final URL mServerUrl;
    protected final HttpHelper mHttpHelper;
    protected final DracoonApi mApi;
    protected final DracoonErrorParser mErrorParser;
    protected final EncryptionPasswordHolder mEncPasswordHolder;
    protected final CryptoWrapper mCryptoWrapper;
    protected ThreadHelper mThreadHelper;
    protected FileStreamHelper mFileStreamHelper;

    protected BaseService(ServiceLocator serviceLocator, ServiceDependencies serviceDependencies) {
        this.mServiceLocator = serviceLocator;
        this.mLog = serviceDependencies.getLog();
        this.mServerUrl = serviceDependencies.getServerUrl();
        this.mHttpHelper = serviceDependencies.getHttpHelper();
        this.mApi = serviceDependencies.getDracoonApi();
        this.mErrorParser = serviceDependencies.getDracoonErrorParser();
        this.mEncPasswordHolder = serviceDependencies.getEncryptionPasswordHolder();
        this.mCryptoWrapper = serviceDependencies.getCryptoWrapper();
        this.mThreadHelper = serviceDependencies.getThreadHelper();
        this.mFileStreamHelper = serviceDependencies.getFileStreamHelper();
    }

    protected String buildApiUrl(String ... pathSegments) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mServerUrl);
        sb.append("/api/v4");
        for (String pathSegment : pathSegments) {
            sb.append("/").append(pathSegment);
        }
        return sb.toString();
    }
}

