/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonException;
import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.service.DownloadStream;
import com.dracoon.sdk.model.FileDownloadCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DownloadThread
extends Thread {
    private static final String LOG_TAG = DownloadThread.class.getSimpleName();
    private static final int BLOCK_SIZE = 2048;
    private final Log mLog;
    private final String mId;
    private final DownloadStream mDownloadStream;
    private final OutputStream mOutputStream;
    private Thread mThread;
    private final List<FileDownloadCallback> mCallbacks = new ArrayList<FileDownloadCallback>();

    private DownloadThread(Log log, DownloadStream.Factory downloadStreamFactory, String id, long nodeId, PlainFileKey fileKey, OutputStream outputStream) {
        this.mLog = log;
        this.mId = id;
        this.mDownloadStream = downloadStreamFactory.create(id, nodeId, fileKey);
        this.mOutputStream = outputStream;
    }

    public void addCallback(FileDownloadCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
            this.mDownloadStream.addCallback(callback);
        }
    }

    public void removeCallback(FileDownloadCallback callback) {
        if (callback != null) {
            this.mCallbacks.remove(callback);
            this.mDownloadStream.removeCallback(callback);
        }
    }

    @Override
    public void run() {
        this.mThread = this;
        try {
            this.download();
        }
        catch (DracoonException dracoonException) {
            // empty catch block
        }
    }

    public void runSync() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        this.mThread = Thread.currentThread();
        this.download();
    }

    private void download() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        try {
            int bytesRead;
            this.mDownloadStream.start();
            byte[] buffer = new byte[2048];
            while ((bytesRead = this.mDownloadStream.read(buffer)) != -1) {
                this.mOutputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            if (this.mThread.isInterrupted()) {
                this.notifyCanceled(this.mId);
                return;
            }
            Throwable cause = e.getCause();
            if (cause instanceof DracoonException) {
                this.rethrow((DracoonException)cause);
            }
            String errorText = "File write failed!";
            this.mLog.d(LOG_TAG, errorText);
            DracoonFileIOException ex = new DracoonFileIOException(errorText, e);
            this.notifyFailed(this.mId, ex);
            throw ex;
        }
    }

    private void rethrow(DracoonException e) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        if (e instanceof DracoonNetIOException) {
            throw (DracoonNetIOException)e;
        }
        if (e instanceof DracoonApiException) {
            throw (DracoonApiException)e;
        }
        if (e instanceof DracoonCryptoException) {
            throw (DracoonCryptoException)e;
        }
        if (e instanceof DracoonFileIOException) {
            throw (DracoonFileIOException)e;
        }
    }

    private void notifyCanceled(String id) {
        for (FileDownloadCallback callback : this.mCallbacks) {
            callback.onCanceled(id);
        }
    }

    private void notifyFailed(String id, DracoonException e) {
        for (FileDownloadCallback callback : this.mCallbacks) {
            callback.onFailed(id, e);
        }
    }

    public static class Factory {
        private final Log mLog;
        private final DownloadStream.Factory mDownloadStreamFactory;

        public Factory(Log log, DownloadStream.Factory downloadStreamFactory) {
            this.mLog = log;
            this.mDownloadStreamFactory = downloadStreamFactory;
        }

        public DownloadThread create(String id, long nodeId, PlainFileKey fileKey, OutputStream outputStream) {
            return new DownloadThread(this.mLog, this.mDownloadStreamFactory, id, nodeId, fileKey, outputStream);
        }
    }
}

