/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoCode;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.api.DracoonApi;
import com.dracoon.sdk.internal.api.DracoonErrorParser;
import com.dracoon.sdk.internal.api.mapper.FileMapper;
import com.dracoon.sdk.internal.api.model.ApiFileKey;
import com.dracoon.sdk.internal.crypto.CryptoErrorParser;
import com.dracoon.sdk.internal.crypto.CryptoVersionConverter;
import com.dracoon.sdk.internal.crypto.CryptoWrapper;
import com.dracoon.sdk.internal.crypto.EncryptionPasswordHolder;
import com.dracoon.sdk.internal.http.HttpHelper;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import retrofit2.Call;
import retrofit2.Response;

public class FileKeyFetcher {
    private static final String LOG_TAG = FileKeyFetcher.class.getSimpleName();
    private final ServiceLocator mServiceLocator;
    private final Log mLog;
    private final DracoonApi mApi;
    private final HttpHelper mHttpHelper;
    private final DracoonErrorParser mErrorParser;
    private final EncryptionPasswordHolder mEncPasswordHolder;
    private final CryptoWrapper mCryptoWrapper;

    public FileKeyFetcher(ServiceLocator serviceLocator, ServiceDependencies serviceDependencies) {
        this.mServiceLocator = serviceLocator;
        this.mLog = serviceDependencies.getLog();
        this.mApi = serviceDependencies.getDracoonApi();
        this.mHttpHelper = serviceDependencies.getHttpHelper();
        this.mErrorParser = serviceDependencies.getDracoonErrorParser();
        this.mEncPasswordHolder = serviceDependencies.getEncryptionPasswordHolder();
        this.mCryptoWrapper = serviceDependencies.getCryptoWrapper();
    }

    public PlainFileKey getPlainFileKey(long nodeId) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        if (!this.mServiceLocator.getNodesService().isNodeEncrypted(nodeId)) {
            return null;
        }
        char[] userPrivateKeyPassword = this.mEncPasswordHolder.getOrAbort();
        EncryptedFileKey encFileKey = this.getFileKey(nodeId);
        UserKeyPair.Version userKeyPairVersion = CryptoVersionConverter.determineUserKeyPairVersion((EncryptedFileKey.Version)encFileKey.getVersion());
        UserKeyPair userKeyPair = this.mServiceLocator.getAccountService().getAndCheckUserKeyPair(userKeyPairVersion);
        return this.mCryptoWrapper.decryptFileKey(nodeId, encFileKey, userKeyPair.getUserPrivateKey(), userPrivateKeyPassword);
    }

    private EncryptedFileKey getFileKey(long nodeId) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        Call<ApiFileKey> call = this.mApi.getFileKey(nodeId);
        Response<ApiFileKey> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFileKeyQueryError(response);
            String errorText = String.format("Query of file key for node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiFileKey data = (ApiFileKey)response.body();
        try {
            return FileMapper.fromApiFileKey(data);
        }
        catch (UnknownVersionException e) {
            String errorText = String.format("Query of file key for node '%d' failed! File key version is unknown!", nodeId);
            this.mLog.d(LOG_TAG, errorText);
            DracoonCryptoCode errorCode = CryptoErrorParser.parseCause((Exception)((Object)e));
            throw new DracoonCryptoException(errorCode, (Throwable)e);
        }
    }
}

