/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.api.DracoonApi;
import com.dracoon.sdk.internal.api.DracoonErrorParser;
import com.dracoon.sdk.internal.api.mapper.FileMapper;
import com.dracoon.sdk.internal.api.mapper.UserMapper;
import com.dracoon.sdk.internal.api.model.ApiFileIdFileKey;
import com.dracoon.sdk.internal.api.model.ApiFileKey;
import com.dracoon.sdk.internal.api.model.ApiMissingFileKeys;
import com.dracoon.sdk.internal.api.model.ApiSetFileKeysRequest;
import com.dracoon.sdk.internal.api.model.ApiUserIdFileId;
import com.dracoon.sdk.internal.api.model.ApiUserIdFileIdFileKey;
import com.dracoon.sdk.internal.api.model.ApiUserIdUserPublicKey;
import com.dracoon.sdk.internal.crypto.CryptoVersionConverter;
import com.dracoon.sdk.internal.crypto.CryptoWrapper;
import com.dracoon.sdk.internal.crypto.EncryptionPasswordHolder;
import com.dracoon.sdk.internal.http.HttpHelper;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.internal.validator.BaseValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class FileKeyGenerator {
    private static final String LOG_TAG = FileKeyGenerator.class.getSimpleName();
    private final ServiceLocator mServiceLocator;
    private final Log mLog;
    private final DracoonApi mApi;
    private final HttpHelper mHttpHelper;
    private final DracoonErrorParser mErrorParser;
    private final EncryptionPasswordHolder mEncPasswordHolder;
    private final CryptoWrapper mCryptoWrapper;

    public FileKeyGenerator(ServiceLocator serviceLocator, ServiceDependencies serviceDependencies) {
        this.mServiceLocator = serviceLocator;
        this.mLog = serviceDependencies.getLog();
        this.mApi = serviceDependencies.getDracoonApi();
        this.mHttpHelper = serviceDependencies.getHttpHelper();
        this.mErrorParser = serviceDependencies.getDracoonErrorParser();
        this.mEncPasswordHolder = serviceDependencies.getEncryptionPasswordHolder();
        this.mCryptoWrapper = serviceDependencies.getCryptoWrapper();
    }

    public boolean generateMissingFileKeys(Long nodeId, Integer limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        BaseValidator.validateLimit(limit, false);
        List<UserKeyPair> userKeyPairs = this.mServiceLocator.getAccountService().getAndCheckUserKeyPairs();
        Map<UserKeyPair.Version, UserPrivateKey> userPrivateKeys = FileKeyGenerator.convertUserPrivateKeys(userKeyPairs);
        char[] userPrivateKeyPassword = this.mEncPasswordHolder.getOrAbort();
        boolean isFinished = false;
        long batchOffset = 0L;
        long batchMaxLimit = 10L;
        while (!isFinished) {
            long batchLimit = Math.min((long)limit.intValue() - batchOffset, batchMaxLimit);
            isFinished = this.generateMissingFileKeysBatch(userPrivateKeys, userPrivateKeyPassword, nodeId, batchOffset, batchLimit);
            if ((batchOffset += batchLimit) < (long)limit.intValue()) continue;
            break;
        }
        return isFinished;
    }

    private static Map<UserKeyPair.Version, UserPrivateKey> convertUserPrivateKeys(List<UserKeyPair> userKeyPairs) {
        HashMap<UserKeyPair.Version, UserPrivateKey> userPrivateKeys = new HashMap<UserKeyPair.Version, UserPrivateKey>();
        for (UserKeyPair userKeyPair : userKeyPairs) {
            UserPrivateKey userPrivateKey = userKeyPair.getUserPrivateKey();
            userPrivateKeys.put(userPrivateKey.getVersion(), userPrivateKey);
        }
        return userPrivateKeys;
    }

    private boolean generateMissingFileKeysBatch(Map<UserKeyPair.Version, UserPrivateKey> userPrivateKeys, char[] userPrivateKeyPassword, Long nodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        ApiMissingFileKeys apiMissingFileKeys = this.getMissingFileKeysBatch(nodeId, offset, limit);
        if (apiMissingFileKeys.items.isEmpty()) {
            return true;
        }
        List<ApiUserIdFileId> apiUserIdFileIds = apiMissingFileKeys.items;
        Map<Long, List<UserPublicKey>> usersPublicKeys = FileKeyGenerator.convertUserPublicKeys(apiMissingFileKeys.users);
        Map<Long, List<EncryptedFileKey>> encFilesKeys = FileKeyGenerator.convertFileKeys(apiMissingFileKeys.files);
        Map<Long, PlainFileKey> plainFileKeys = this.decryptFileKeys(encFilesKeys, userPrivateKeys, userPrivateKeyPassword);
        ArrayList<ApiUserIdFileIdFileKey> apiUserIdFileIdFileKeys = new ArrayList<ApiUserIdFileIdFileKey>();
        for (ApiUserIdFileId apiUserIdFileId : apiUserIdFileIds) {
            List<UserPublicKey> userPublicKeys = usersPublicKeys.get(apiUserIdFileId.userId);
            PlainFileKey plainFileKey = plainFileKeys.get(apiUserIdFileId.fileId);
            if (userPublicKeys == null || plainFileKey == null) continue;
            for (UserPublicKey userPublicKey : userPublicKeys) {
                EncryptedFileKey encFileKey = this.mCryptoWrapper.encryptFileKey(apiUserIdFileId.fileId, plainFileKey, userPublicKey);
                ApiFileKey apiFileKey = FileMapper.toApiFileKey(encFileKey);
                ApiUserIdFileIdFileKey apiUserIdFileIdFileKey = new ApiUserIdFileIdFileKey();
                apiUserIdFileIdFileKey.userId = apiUserIdFileId.userId;
                apiUserIdFileIdFileKey.fileId = apiUserIdFileId.fileId;
                apiUserIdFileIdFileKey.fileKey = apiFileKey;
                apiUserIdFileIdFileKeys.add(apiUserIdFileIdFileKey);
            }
        }
        this.setFileKeysBatch(apiUserIdFileIdFileKeys);
        return apiMissingFileKeys.range.total <= offset + limit;
    }

    private ApiMissingFileKeys getMissingFileKeysBatch(Long nodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        Call<ApiMissingFileKeys> call = this.mApi.getMissingFileKeys(nodeId, offset, limit);
        Response<ApiMissingFileKeys> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseMissingFileKeysQueryError(response);
            String errorText = String.format("Query of missing file keys failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return (ApiMissingFileKeys)response.body();
    }

    private static Map<Long, List<UserPublicKey>> convertUserPublicKeys(List<ApiUserIdUserPublicKey> apiUserIdUserPublicKeys) {
        HashMap<Long, List<UserPublicKey>> usersPublicKeys = new HashMap<Long, List<UserPublicKey>>();
        for (ApiUserIdUserPublicKey apiUserIdUserPublicKey : apiUserIdUserPublicKeys) {
            try {
                UserPublicKey userPublicKey = UserMapper.fromApiUserPublicKey(apiUserIdUserPublicKey.publicKeyContainer);
                List userPublicKeys = (List)usersPublicKeys.get(apiUserIdUserPublicKey.id);
                if (userPublicKeys != null) {
                    userPublicKeys.add(userPublicKey);
                    continue;
                }
                usersPublicKeys.put(apiUserIdUserPublicKey.id, Collections.singletonList(userPublicKey));
            }
            catch (UnknownVersionException unknownVersionException) {}
        }
        return usersPublicKeys;
    }

    private static Map<Long, List<EncryptedFileKey>> convertFileKeys(List<ApiFileIdFileKey> apiFileIdFileKeys) {
        HashMap<Long, List<EncryptedFileKey>> encFilesKeys = new HashMap<Long, List<EncryptedFileKey>>();
        for (ApiFileIdFileKey apiFileIdFileKey : apiFileIdFileKeys) {
            try {
                EncryptedFileKey encFileKey = FileMapper.fromApiFileKey(apiFileIdFileKey.fileKeyContainer);
                List encFileKeys = (List)encFilesKeys.get(apiFileIdFileKey.id);
                if (encFileKeys != null) {
                    encFileKeys.add(encFileKey);
                    continue;
                }
                encFilesKeys.put(apiFileIdFileKey.id, Collections.singletonList(encFileKey));
            }
            catch (UnknownVersionException unknownVersionException) {}
        }
        return encFilesKeys;
    }

    private Map<Long, PlainFileKey> decryptFileKeys(Map<Long, List<EncryptedFileKey>> encFilesKeys, Map<UserKeyPair.Version, UserPrivateKey> userPrivateKeys, char[] userPrivateKeyPassword) throws DracoonCryptoException {
        HashMap<Long, PlainFileKey> plainFileKeys = new HashMap<Long, PlainFileKey>();
        block0: for (Map.Entry<Long, List<EncryptedFileKey>> encFileKeys : encFilesKeys.entrySet()) {
            for (EncryptedFileKey encFileKey : encFileKeys.getValue()) {
                UserKeyPair.Version userKeyPairVersion = CryptoVersionConverter.determineUserKeyPairVersion((EncryptedFileKey.Version)encFileKey.getVersion());
                UserPrivateKey userPrivateKey = userPrivateKeys.get(userKeyPairVersion);
                if (userPrivateKey == null) continue;
                PlainFileKey plainFileKey = this.mCryptoWrapper.decryptFileKey(encFileKeys.getKey(), encFileKey, userPrivateKey, userPrivateKeyPassword);
                plainFileKeys.put(encFileKeys.getKey(), plainFileKey);
                continue block0;
            }
        }
        return plainFileKeys;
    }

    private void setFileKeysBatch(List<ApiUserIdFileIdFileKey> apiUserIdFileIdFileKeys) throws DracoonNetIOException, DracoonApiException {
        ApiSetFileKeysRequest request = new ApiSetFileKeysRequest();
        request.items = apiUserIdFileIdFileKeys;
        Call<Void> call = this.mApi.setFileKeys(request);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFileKeysSetError(response);
            String errorText = String.format("Setting missing file keys failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }
}

