/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonFileNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileStreamHelper {
    public InputStream getFileInputStream(File file) throws DracoonFileIOException {
        if (!file.exists()) {
            throw new DracoonFileNotFoundException("File not found.");
        }
        if (!file.canRead()) {
            throw new DracoonFileNotFoundException("File not readable.");
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new DracoonFileIOException("File cannot be opened.", e);
        }
    }

    public OutputStream getFileOutputStream(File file) throws DracoonFileIOException {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new DracoonFileIOException("File cannot be opened.", e);
        }
    }
}

