/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonException;
import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.filter.FavoriteStatusFilter;
import com.dracoon.sdk.filter.Filters;
import com.dracoon.sdk.filter.GetNodesFilters;
import com.dracoon.sdk.filter.NodeParentPathFilter;
import com.dracoon.sdk.filter.SearchNodesFilters;
import com.dracoon.sdk.internal.ClientImpl;
import com.dracoon.sdk.internal.ClientMethodImpl;
import com.dracoon.sdk.internal.api.mapper.FileMapper;
import com.dracoon.sdk.internal.api.mapper.FolderMapper;
import com.dracoon.sdk.internal.api.mapper.NodeMapper;
import com.dracoon.sdk.internal.api.mapper.RoomMapper;
import com.dracoon.sdk.internal.api.model.ApiCopyNodesRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateFolderRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateNodeCommentRequest;
import com.dracoon.sdk.internal.api.model.ApiCreateRoomRequest;
import com.dracoon.sdk.internal.api.model.ApiDeleteNodesRequest;
import com.dracoon.sdk.internal.api.model.ApiGetNodesVirusProtectionInfoRequest;
import com.dracoon.sdk.internal.api.model.ApiMoveNodesRequest;
import com.dracoon.sdk.internal.api.model.ApiNode;
import com.dracoon.sdk.internal.api.model.ApiNodeComment;
import com.dracoon.sdk.internal.api.model.ApiNodeCommentList;
import com.dracoon.sdk.internal.api.model.ApiNodeList;
import com.dracoon.sdk.internal.api.model.ApiNodeVirusProtectionInfo;
import com.dracoon.sdk.internal.api.model.ApiUpdateFileRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateFolderRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateNodeCommentRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateRoomConfigRequest;
import com.dracoon.sdk.internal.api.model.ApiUpdateRoomRequest;
import com.dracoon.sdk.internal.crypto.CryptoVersionConverter;
import com.dracoon.sdk.internal.http.HttpStatus;
import com.dracoon.sdk.internal.service.BaseService;
import com.dracoon.sdk.internal.service.DownloadStream;
import com.dracoon.sdk.internal.service.DownloadThread;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.internal.service.UploadStream;
import com.dracoon.sdk.internal.service.UploadThread;
import com.dracoon.sdk.internal.util.StreamUtils;
import com.dracoon.sdk.internal.validator.BaseValidator;
import com.dracoon.sdk.internal.validator.FileValidator;
import com.dracoon.sdk.internal.validator.FolderValidator;
import com.dracoon.sdk.internal.validator.NodeValidator;
import com.dracoon.sdk.internal.validator.RoomValidator;
import com.dracoon.sdk.model.CopyNodesRequest;
import com.dracoon.sdk.model.CreateFolderRequest;
import com.dracoon.sdk.model.CreateNodeCommentRequest;
import com.dracoon.sdk.model.CreateRoomRequest;
import com.dracoon.sdk.model.DeleteNodesRequest;
import com.dracoon.sdk.model.FileDownloadCallback;
import com.dracoon.sdk.model.FileDownloadStream;
import com.dracoon.sdk.model.FileUploadCallback;
import com.dracoon.sdk.model.FileUploadRequest;
import com.dracoon.sdk.model.FileUploadStream;
import com.dracoon.sdk.model.FileVirusScanInfo;
import com.dracoon.sdk.model.FileVirusScanInfoList;
import com.dracoon.sdk.model.GetFilesVirusScanInfoRequest;
import com.dracoon.sdk.model.MoveNodesRequest;
import com.dracoon.sdk.model.Node;
import com.dracoon.sdk.model.NodeComment;
import com.dracoon.sdk.model.NodeCommentList;
import com.dracoon.sdk.model.NodeList;
import com.dracoon.sdk.model.UpdateFileRequest;
import com.dracoon.sdk.model.UpdateFolderRequest;
import com.dracoon.sdk.model.UpdateNodeCommentRequest;
import com.dracoon.sdk.model.UpdateRoomConfigRequest;
import com.dracoon.sdk.model.UpdateRoomRequest;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

@ClientImpl(value=DracoonClient.Nodes.class)
public class NodesService
extends BaseService {
    private static final String LOG_TAG = NodesService.class.getSimpleName();
    private static final String MEDIA_URL_TEMPLATE = "%s/mediaserver/image/%s/%dx%d";
    private final Map<String, UploadThread> mUploads = new HashMap<String, UploadThread>();
    private final Map<String, DownloadThread> mDownloads = new HashMap<String, DownloadThread>();

    public NodesService(ServiceLocator locator, ServiceDependencies dependencies) {
        super(locator, dependencies);
    }

    UploadThread getUploadThread(String id) {
        return this.mUploads.get(id);
    }

    void putUploadThread(String id, UploadThread uploadThread) {
        this.mUploads.put(id, uploadThread);
    }

    DownloadThread getDownloadThread(String id) {
        return this.mDownloads.get(id);
    }

    void putDownloadThread(String id, DownloadThread downloadThread) {
        this.mDownloads.put(id, downloadThread);
    }

    @ClientMethodImpl
    public NodeList getNodes(long parentNodeId) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, null, null, null);
    }

    @ClientMethodImpl
    public NodeList getNodes(long parentNodeId, GetNodesFilters filters) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, filters, null, null);
    }

    @ClientMethodImpl
    public NodeList getNodes(long parentNodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, null, offset, limit);
    }

    @ClientMethodImpl
    public NodeList getNodes(long parentNodeId, GetNodesFilters filters, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.getNodesInternally(parentNodeId, filters, offset, limit);
    }

    private NodeList getNodesInternally(long parentNodeId, Filters filters, Long offset, Long limit) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateParentNodeId(parentNodeId);
        BaseValidator.validateRange(offset, limit, true);
        String filter = filters != null ? filters.toString() : null;
        Call<ApiNodeList> call = this.mApi.getNodes(parentNodeId, 0, filter, null, offset, limit);
        Response<ApiNodeList> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesQueryError(response);
            String errorText = String.format("Query of child nodes of node '%d' failed with '%s'!", parentNodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeList data = (ApiNodeList)response.body();
        return NodeMapper.fromApiNodeList(data);
    }

    @ClientMethodImpl
    public Node getNode(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<ApiNode> call = this.mApi.getNode(nodeId);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesQueryError(response);
            String errorText = String.format("Query of node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node getNode(String nodePath) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodePath(nodePath);
        int slashPos = nodePath.lastIndexOf(47);
        String path = nodePath.substring(0, slashPos + 1);
        String name = nodePath.substring(slashPos + 1, nodePath.length());
        NodeParentPathFilter pathFilter = new NodeParentPathFilter.Builder().eq(path).build();
        SearchNodesFilters filters = new SearchNodesFilters();
        filters.addNodeParentPathFilter(pathFilter);
        NodeList nodeList = this.searchNodes(0L, name, filters);
        if (nodeList.getItems().isEmpty()) {
            DracoonApiCode errorCode = DracoonApiCode.SERVER_NODE_NOT_FOUND;
            String errorText = String.format("Query of node '%s' failed with '%s'!", nodePath, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return nodeList.getItems().get(0);
    }

    public boolean isNodeEncrypted(long nodeId) throws DracoonNetIOException, DracoonApiException {
        Node node = this.getNode(nodeId);
        return node.isEncrypted();
    }

    @ClientMethodImpl
    public Node createRoom(CreateRoomRequest request) throws DracoonNetIOException, DracoonApiException {
        RoomValidator.validateCreateRequest(request);
        ApiCreateRoomRequest apiRequest = RoomMapper.toApiCreateRoomRequest(request);
        Call<ApiNode> call = this.mApi.createRoom(apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseRoomCreateError(response);
            String errorText = String.format("Creation of room '%s' failed with '%s'!", request.getName(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node updateRoom(UpdateRoomRequest request) throws DracoonNetIOException, DracoonApiException {
        RoomValidator.validateUpdateRequest(request);
        ApiUpdateRoomRequest apiRequest = RoomMapper.toApiUpdateRoomRequest(request);
        Call<ApiNode> call = this.mApi.updateRoom(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseRoomUpdateError(response);
            String errorText = String.format("Update of room '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node updateRoomConfig(UpdateRoomConfigRequest request) throws DracoonNetIOException, DracoonApiException {
        RoomValidator.validateUpdateConfigRequest(request);
        ApiUpdateRoomConfigRequest apiRequest = RoomMapper.toApiUpdateRoomConfigRequest(request);
        Call<ApiNode> call = this.mApi.updateRoomConfig(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseRoomUpdateError(response);
            String errorText = String.format("Update config of room '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node createFolder(CreateFolderRequest request) throws DracoonNetIOException, DracoonApiException {
        FolderValidator.validateCreateRequest(request);
        ApiCreateFolderRequest apiRequest = FolderMapper.toApiCreateFolderRequest(request);
        Call<ApiNode> call = this.mApi.createFolder(apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFolderCreateError(response);
            String errorText = String.format("Creation of folder '%s' failed with '%s'!", request.getName(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node updateFolder(UpdateFolderRequest request) throws DracoonNetIOException, DracoonApiException {
        FolderValidator.validateUpdateRequest(request);
        ApiUpdateFolderRequest apiRequest = FolderMapper.toApiUpdateFolderRequest(request);
        Call<ApiNode> call = this.mApi.updateFolder(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFolderUpdateError(response);
            String errorText = String.format("Update of folder '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node updateFile(UpdateFileRequest request) throws DracoonNetIOException, DracoonApiException {
        FileValidator.validateUpdateRequest(request);
        ApiUpdateFileRequest apiRequest = FileMapper.toApiUpdateFileRequest(request);
        Call<ApiNode> call = this.mApi.updateFile(request.getId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFileUpdateError(response);
            String errorText = String.format("Update of file '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public void deleteNodes(DeleteNodesRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateDeleteRequest(request);
        ApiDeleteNodesRequest apiRequest = NodeMapper.toApiDeleteNodesRequest(request);
        Call<Void> call = this.mApi.deleteNodes(apiRequest);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesDeleteError(response);
            String errorText = String.format("Deletion of nodes %s failed with '%s'!", request.getIds(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @ClientMethodImpl
    public void deleteNode(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mApi.deleteNode(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesDeleteError(response);
            String errorText = String.format("Deletion of node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @ClientMethodImpl
    public Node copyNodes(CopyNodesRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateCopyRequest(request);
        ApiCopyNodesRequest apiRequest = NodeMapper.toApiCopyNodesRequest(request);
        Call<ApiNode> call = this.mApi.copyNodes(request.getTargetNodeId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesCopyError(response);
            String errorText = String.format("Copy to node '%d' failed with '%s'!", request.getTargetNodeId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node moveNodes(MoveNodesRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateMoveRequest(request);
        ApiMoveNodesRequest apiRequest = NodeMapper.toApiMoveNodesRequest(request);
        Call<ApiNode> call = this.mApi.moveNodes(request.getTargetNodeId(), apiRequest);
        Response<ApiNode> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesMoveError(response);
            String errorText = String.format("Move to node '%d' failed with '%s'!", request.getTargetNodeId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNode data = (ApiNode)response.body();
        return NodeMapper.fromApiNode(data);
    }

    @ClientMethodImpl
    public Node uploadFile(String id, FileUploadRequest request, File file, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, file);
        InputStream is = this.mFileStreamHelper.getFileInputStream(file);
        long length = file.length();
        return this.uploadFileInternally(id, request, is, length, true, callback);
    }

    @ClientMethodImpl
    public Node uploadFile(String id, FileUploadRequest request, InputStream is, long length, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, is);
        return this.uploadFileInternally(id, request, is, length, false, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node uploadFileInternally(String id, FileUploadRequest request, InputStream is, long length, boolean close, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        Node node;
        UserPublicKey userPublicKey = this.getUploadUserPublicKey(request.getParentId());
        PlainFileKey plainFileKey = this.createUploadFileKey(userPublicKey);
        UploadThread.Factory factory = this.mServiceLocator.getUploadThreadFactory();
        UploadThread thread = factory.create(id, request, length, userPublicKey, plainFileKey, is);
        thread.addCallback(callback);
        try {
            node = thread.runSync();
        }
        finally {
            NodesService.closeStream(is, close);
        }
        return node;
    }

    @ClientMethodImpl
    public void startUploadFileAsync(String id, FileUploadRequest request, File file, FileUploadCallback callback) throws DracoonFileIOException, DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, file);
        InputStream is = this.mFileStreamHelper.getFileInputStream(file);
        long length = file.length();
        this.startUploadFileAsyncInternally(id, request, is, length, true, callback);
    }

    @ClientMethodImpl
    public void startUploadFileAsync(String id, FileUploadRequest request, InputStream is, long length, FileUploadCallback callback) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        FileValidator.validateUploadRequest(id, request, is);
        this.startUploadFileAsyncInternally(id, request, is, length, false, callback);
    }

    private void startUploadFileAsyncInternally(String id, FileUploadRequest request, final InputStream is, long length, final boolean close, FileUploadCallback callback) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        UserPublicKey userPublicKey = this.getUploadUserPublicKey(request.getParentId());
        PlainFileKey plainFileKey = this.createUploadFileKey(userPublicKey);
        FileUploadCallback internalCallback = new FileUploadCallback(){

            @Override
            @ClientMethodImpl
            public void onStarted(String id) {
            }

            @Override
            @ClientMethodImpl
            public void onRunning(String id, long bytesSend, long bytesTotal) {
            }

            @Override
            @ClientMethodImpl
            public void onFinished(String id, Node node) {
                NodesService.closeStream(is, close);
                NodesService.this.mUploads.remove(id);
            }

            @Override
            @ClientMethodImpl
            public void onCanceled(String id) {
                NodesService.closeStream(is, close);
                NodesService.this.mUploads.remove(id);
            }

            @Override
            @ClientMethodImpl
            public void onFailed(String id, DracoonException e) {
                NodesService.closeStream(is, close);
                NodesService.this.mUploads.remove(id);
            }
        };
        UploadThread.Factory factory = this.mServiceLocator.getUploadThreadFactory();
        UploadThread thread = factory.create(id, request, length, userPublicKey, plainFileKey, is);
        thread.addCallback(callback);
        thread.addCallback(internalCallback);
        this.mUploads.put(id, thread);
        thread.start();
    }

    @ClientMethodImpl
    public void cancelUploadFileAsync(String id) {
        UploadThread uploadThread = this.mUploads.get(id);
        if (uploadThread == null) {
            return;
        }
        if (this.mThreadHelper.isThreadAlive(uploadThread)) {
            this.mThreadHelper.interruptThread(uploadThread);
        }
        this.mUploads.remove(id);
    }

    @ClientMethodImpl
    public FileUploadStream createFileUploadStream(String id, FileUploadRequest request, long length, FileUploadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        FileValidator.validateUploadRequest(request);
        UserPublicKey userPublicKey = this.getUploadUserPublicKey(request.getParentId());
        PlainFileKey plainFileKey = this.createUploadFileKey(userPublicKey);
        UploadStream.Factory factory = this.mServiceLocator.getUploadStreamFactory();
        UploadStream stream = factory.create(id, request, length, userPublicKey, plainFileKey);
        if (callback != null) {
            stream.addCallback(callback);
        }
        stream.start();
        return stream;
    }

    private UserPublicKey getUploadUserPublicKey(long parentNodeId) throws DracoonNetIOException, DracoonApiException {
        boolean isEncryptedUpload = this.isNodeEncrypted(parentNodeId);
        if (!isEncryptedUpload) {
            return null;
        }
        UserKeyPair userKeyPair = this.mServiceLocator.getAccountService().getPreferredUserKeyPair();
        return userKeyPair.getUserPublicKey();
    }

    private PlainFileKey createUploadFileKey(UserPublicKey userPublicKey) throws DracoonCryptoException {
        if (userPublicKey == null) {
            return null;
        }
        PlainFileKey.Version version = CryptoVersionConverter.determinePlainFileKeyVersion(userPublicKey.getVersion());
        return this.mCryptoWrapper.generateFileKey(version);
    }

    @ClientMethodImpl
    public void downloadFile(String id, long nodeId, File file, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        FileValidator.validateDownloadRequest(id, file);
        OutputStream os = this.mFileStreamHelper.getFileOutputStream(file);
        this.downloadFileInternally(id, nodeId, os, true, callback);
    }

    @ClientMethodImpl
    public void downloadFile(String id, long nodeId, OutputStream os, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        FileValidator.validateDownloadRequest(id, os);
        this.downloadFileInternally(id, nodeId, os, false, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFileInternally(String id, long nodeId, OutputStream os, boolean close, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        PlainFileKey plainFileKey = this.getDownloadFileKey(nodeId);
        DownloadThread.Factory factory = this.mServiceLocator.getDownloadThreadFactory();
        DownloadThread thread = factory.create(id, nodeId, plainFileKey, os);
        if (callback != null) {
            thread.addCallback(callback);
        }
        try {
            thread.runSync();
        }
        finally {
            NodesService.closeStream(os, close);
        }
    }

    @ClientMethodImpl
    public void startDownloadFileAsync(String id, long nodeId, File file, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        FileValidator.validateDownloadRequest(id, file);
        OutputStream os = this.mFileStreamHelper.getFileOutputStream(file);
        this.startDownloadFileAsyncInternally(id, nodeId, os, true, callback);
    }

    @ClientMethodImpl
    public void startDownloadFileAsync(String id, long nodeId, OutputStream os, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        FileValidator.validateDownloadRequest(id, os);
        this.startDownloadFileAsyncInternally(id, nodeId, os, false, callback);
    }

    private void startDownloadFileAsyncInternally(String id, long nodeId, final OutputStream os, final boolean close, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        PlainFileKey plainFileKey = this.getDownloadFileKey(nodeId);
        FileDownloadCallback stoppedCallback = new FileDownloadCallback(){

            @Override
            @ClientMethodImpl
            public void onStarted(String id) {
            }

            @Override
            @ClientMethodImpl
            public void onRunning(String id, long bytesSend, long bytesTotal) {
            }

            @Override
            @ClientMethodImpl
            public void onFinished(String id) {
                NodesService.closeStream(os, close);
                NodesService.this.mDownloads.remove(id);
            }

            @Override
            @ClientMethodImpl
            public void onCanceled(String id) {
                NodesService.closeStream(os, close);
                NodesService.this.mDownloads.remove(id);
            }

            @Override
            @ClientMethodImpl
            public void onFailed(String id, DracoonException e) {
                NodesService.closeStream(os, close);
                NodesService.this.mDownloads.remove(id);
            }
        };
        DownloadThread.Factory factory = this.mServiceLocator.getDownloadThreadFactory();
        DownloadThread thread = factory.create(id, nodeId, plainFileKey, os);
        thread.addCallback(stoppedCallback);
        if (callback != null) {
            thread.addCallback(callback);
        }
        this.mDownloads.put(id, thread);
        thread.start();
    }

    @ClientMethodImpl
    public void cancelDownloadFileAsync(String id) {
        DownloadThread downloadThread = this.mDownloads.get(id);
        if (downloadThread == null) {
            return;
        }
        if (this.mThreadHelper.isThreadAlive(downloadThread)) {
            this.mThreadHelper.interruptThread(downloadThread);
        }
        this.mDownloads.remove(id);
    }

    @ClientMethodImpl
    public FileDownloadStream createFileDownloadStream(String id, long nodeId, FileDownloadCallback callback) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        PlainFileKey plainFileKey = this.getDownloadFileKey(nodeId);
        DownloadStream.Factory factory = this.mServiceLocator.getDownloadStreamFactory();
        DownloadStream stream = factory.create(id, nodeId, plainFileKey);
        if (callback != null) {
            stream.addCallback(callback);
        }
        stream.start();
        return stream;
    }

    private PlainFileKey getDownloadFileKey(long nodeId) throws DracoonCryptoException, DracoonNetIOException, DracoonApiException {
        return this.mServiceLocator.getFileKeyFetcher().getPlainFileKey(nodeId);
    }

    @ClientMethodImpl
    public NodeList searchNodes(long parentNodeId, String searchString) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, null, null, null);
    }

    @ClientMethodImpl
    public NodeList searchNodes(long parentNodeId, String searchString, SearchNodesFilters filters) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, filters, null, null);
    }

    @ClientMethodImpl
    public NodeList searchNodes(long parentNodeId, String searchString, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, null, offset, limit);
    }

    @ClientMethodImpl
    public NodeList searchNodes(long parentNodeId, String searchString, SearchNodesFilters filters, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.searchNodesInternally(parentNodeId, searchString, filters, offset, limit);
    }

    private NodeList searchNodesInternally(long parentNodeId, String searchString, SearchNodesFilters filters, Long offset, Long limit) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateSearchRequest(parentNodeId, searchString);
        BaseValidator.validateRange(offset, limit, true);
        String filter = filters != null ? filters.toString() : null;
        Call<ApiNodeList> call = this.mApi.searchNodes(searchString, parentNodeId, -1, filter, null, offset, limit);
        Response<ApiNodeList> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesQueryError(response);
            String errorText = String.format("Node search '%s' in node '%d' failed with '%s'!", searchString, parentNodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeList data = (ApiNodeList)response.body();
        return NodeMapper.fromApiNodeList(data);
    }

    @ClientMethodImpl
    public boolean generateMissingFileKeys(int limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        return this.generateMissingFileKeysInternally(null, limit);
    }

    @ClientMethodImpl
    public boolean generateMissingFileKeys(long nodeId, int limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        NodeValidator.validateNodeId(nodeId);
        return this.generateMissingFileKeysInternally(nodeId, limit);
    }

    private boolean generateMissingFileKeysInternally(Long nodeId, Integer limit) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException {
        return this.mServiceLocator.getFileKeyGenerator().generateMissingFileKeys(nodeId, limit);
    }

    @ClientMethodImpl
    public void markFavorite(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mApi.markFavorite(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseFavoriteMarkError(response);
            String errorText = String.format("Mark node %s as favorite failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            if (!errorCode.isValidationError()) {
                throw new DracoonApiException(errorCode);
            }
        }
    }

    @ClientMethodImpl
    public void unmarkFavorite(long nodeId) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mApi.unmarkFavorite(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            if (response.code() == HttpStatus.BAD_REQUEST.getNumber()) {
                return;
            }
            DracoonApiCode errorCode = this.mErrorParser.parseFavoriteMarkError(response);
            String errorText = String.format("Unmark node %s as favorite failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @ClientMethodImpl
    public NodeList getFavorites() throws DracoonNetIOException, DracoonApiException {
        SearchNodesFilters filters = new SearchNodesFilters();
        filters.addFavoriteStatusFilter(new FavoriteStatusFilter.Builder().eq(true).build());
        return this.searchNodes(0L, "*", filters);
    }

    @ClientMethodImpl
    public NodeList getFavorites(long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        SearchNodesFilters filters = new SearchNodesFilters();
        filters.addFavoriteStatusFilter(new FavoriteStatusFilter.Builder().eq(true).build());
        return this.searchNodes(0L, "*", filters, offset, limit);
    }

    @ClientMethodImpl
    public NodeCommentList getNodeComments(long nodeId) throws DracoonNetIOException, DracoonApiException {
        return this.getNodeCommentsInternally(nodeId, null, null);
    }

    @ClientMethodImpl
    public NodeCommentList getNodeComments(long nodeId, long offset, long limit) throws DracoonNetIOException, DracoonApiException {
        return this.getNodeCommentsInternally(nodeId, offset, limit);
    }

    private NodeCommentList getNodeCommentsInternally(long nodeId, Long offset, Long limit) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateNodeId(nodeId);
        BaseValidator.validateRange(offset, limit, true);
        Call<ApiNodeCommentList> call = this.mApi.getNodeComments(nodeId, offset, limit);
        Response<ApiNodeCommentList> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentsQueryError(response);
            String errorText = String.format("Query of node comments for node '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeCommentList data = (ApiNodeCommentList)response.body();
        return NodeMapper.fromApiNodeCommentList(data);
    }

    @ClientMethodImpl
    public NodeComment createNodeComment(CreateNodeCommentRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateCreateCommentRequest(request);
        ApiCreateNodeCommentRequest apiRequest = NodeMapper.toApiCreateNodeCommentRequest(request);
        Call<ApiNodeComment> call = this.mApi.createNodeComment(request.getNodeId(), apiRequest);
        Response<ApiNodeComment> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentCreateError(response);
            String errorText = String.format("Creation of comment on node '%d' failed with '%s'!", request.getNodeId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeComment data = (ApiNodeComment)response.body();
        return NodeMapper.fromApiNodeComment(data);
    }

    @ClientMethodImpl
    public NodeComment updateNodeComment(UpdateNodeCommentRequest request) throws DracoonNetIOException, DracoonApiException {
        NodeValidator.validateUpdateCommentRequest(request);
        ApiUpdateNodeCommentRequest apiRequest = NodeMapper.toApiUpdateNodeCommentRequest(request);
        Call<ApiNodeComment> call = this.mApi.updateNodeComment(request.getId(), apiRequest);
        Response<ApiNodeComment> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentUpdateError(response);
            String errorText = String.format("Update of comment '%d' failed with '%s'!", request.getId(), errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiNodeComment data = (ApiNodeComment)response.body();
        return NodeMapper.fromApiNodeComment(data);
    }

    @ClientMethodImpl
    public void deleteNodeComment(long commentId) throws DracoonNetIOException, DracoonApiException {
        BaseValidator.validateCommentId(commentId);
        Call<Void> call = this.mApi.deleteNodeComment(commentId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodeCommentDeleteError(response);
            String errorText = String.format("Deletion of comment '%d' failed with '%s'!", commentId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    @ClientMethodImpl
    public FileVirusScanInfoList getFilesVirusScanInformation(GetFilesVirusScanInfoRequest request) throws DracoonNetIOException, DracoonApiException {
        this.checkVirusScanningSupported();
        NodeValidator.validateGetVirusScanInfoRequest(request);
        return this.getFilesVirusScanInformationInternally(request.getIds());
    }

    @ClientMethodImpl
    public FileVirusScanInfo getFileVirusScanInformation(long nodeId) throws DracoonNetIOException, DracoonApiException {
        this.checkVirusScanningSupported();
        NodeValidator.validateNodeId(nodeId);
        FileVirusScanInfoList fileVirusScanInfoList = this.getFilesVirusScanInformationInternally(Collections.singletonList(nodeId));
        if (fileVirusScanInfoList == null) {
            return null;
        }
        return !fileVirusScanInfoList.getItems().isEmpty() ? fileVirusScanInfoList.getItems().get(0) : null;
    }

    private FileVirusScanInfoList getFilesVirusScanInformationInternally(List<Long> nodeIds) throws DracoonNetIOException, DracoonApiException {
        ApiGetNodesVirusProtectionInfoRequest request = new ApiGetNodesVirusProtectionInfoRequest();
        request.nodeIds = nodeIds;
        Call<List<ApiNodeVirusProtectionInfo>> call = this.mApi.getNodesVirusProtectionInfo(request);
        Response<List<ApiNodeVirusProtectionInfo>> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseNodesVirusProtectionInfoGetError(response);
            String errorText = String.format("Retrieval of virus scan info of nodes %s failed with '%s'!", nodeIds, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        List data = (List)response.body();
        return NodeMapper.fromApiNodeVirusProtectionInfos(data);
    }

    @ClientMethodImpl
    public void deleteMaliciousFile(long nodeId) throws DracoonNetIOException, DracoonApiException {
        this.checkVirusScanningSupported();
        NodeValidator.validateNodeId(nodeId);
        Call<Void> call = this.mApi.deleteMaliciousFile(nodeId);
        Response<Void> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseMaliciousFileDeleteError(response);
            String errorText = String.format("Deletion of malicious file '%d' failed with '%s'!", nodeId, errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
    }

    private void checkVirusScanningSupported() throws DracoonNetIOException, DracoonApiException {
        this.mServiceLocator.getServerInfoService().checkVersionGreaterEqual("4.44.0");
    }

    @ClientMethodImpl
    public URL buildMediaUrl(String mediaToken, int width, int height) {
        NodeValidator.validateMediaUrlRequest(mediaToken, width, height);
        String url = String.format(MEDIA_URL_TEMPLATE, this.mServerUrl, mediaToken, width, height);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    private static void closeStream(InputStream is, boolean close) {
        if (close) {
            StreamUtils.closeStream(is);
        }
    }

    private static void closeStream(OutputStream os, boolean close) {
        if (close) {
            StreamUtils.closeStream(os);
        }
    }
}

