/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.ClientImpl;
import com.dracoon.sdk.internal.ClientMethodImpl;
import com.dracoon.sdk.internal.api.model.ApiServerInfo;
import com.dracoon.sdk.internal.api.model.ApiServerTime;
import com.dracoon.sdk.internal.service.BaseService;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.internal.util.VersionUtils;
import java.util.Date;
import retrofit2.Call;
import retrofit2.Response;

@ClientImpl(value=DracoonClient.Server.class)
public class ServerInfoService
extends BaseService {
    private static final String LOG_TAG = ServerInfoService.class.getSimpleName();
    private ApiServerInfo mCachedServerInfo;

    public ServerInfoService(ServiceLocator locator, ServiceDependencies dependencies) {
        super(locator, dependencies);
    }

    public void checkVersionSupported() throws DracoonNetIOException, DracoonApiException {
        if (!this.isVersionGreaterEqual("4.33.0")) {
            throw new DracoonApiException(DracoonApiCode.API_VERSION_NOT_SUPPORTED);
        }
    }

    public void checkVersionGreaterEqual(String version) throws DracoonNetIOException, DracoonApiException {
        if (!this.isVersionGreaterEqual(version)) {
            throw new DracoonApiException(DracoonApiCode.API_VERSION_NOT_SUFFICIENT);
        }
    }

    private boolean isVersionGreaterEqual(String version) throws DracoonNetIOException, DracoonApiException {
        String actualVersion = this.getVersion();
        return VersionUtils.isVersionGreaterEqual(actualVersion, version);
    }

    @ClientMethodImpl
    public String getVersion() throws DracoonNetIOException, DracoonApiException {
        return this.getServerInfo().restApiVersion;
    }

    @ClientMethodImpl
    public Boolean isDracoonCloud() throws DracoonNetIOException, DracoonApiException {
        return this.getServerInfo().isDracoonCloud;
    }

    private ApiServerInfo getServerInfo() throws DracoonNetIOException, DracoonApiException {
        if (this.mCachedServerInfo != null) {
            return this.mCachedServerInfo;
        }
        Call<ApiServerInfo> call = this.mApi.getServerInfo();
        Response<ApiServerInfo> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseServerInfoQueryError(response);
            String errorText = String.format("Query of server info failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        this.mCachedServerInfo = (ApiServerInfo)response.body();
        return this.mCachedServerInfo;
    }

    @ClientMethodImpl
    public Date getTime() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerTime> call = this.mApi.getServerTime();
        Response<ApiServerTime> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of server time failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return ((ApiServerTime)response.body()).time;
    }
}

