/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.error.DracoonApiCode;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.ClientImpl;
import com.dracoon.sdk.internal.ClientMethodImpl;
import com.dracoon.sdk.internal.api.mapper.ServerMapper;
import com.dracoon.sdk.internal.api.model.ApiServerCryptoAlgorithms;
import com.dracoon.sdk.internal.api.model.ApiServerDefaults;
import com.dracoon.sdk.internal.api.model.ApiServerGeneralSettings;
import com.dracoon.sdk.internal.api.model.ApiUserKeyPairAlgorithm;
import com.dracoon.sdk.internal.service.BaseService;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.model.ServerDefaults;
import com.dracoon.sdk.model.ServerGeneralSettings;
import com.dracoon.sdk.model.UserKeyPairAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

@ClientImpl(value=DracoonClient.ServerSettings.class)
public class ServerSettingsService
extends BaseService {
    private static final String LOG_TAG = ServerSettingsService.class.getSimpleName();
    private static final UserKeyPair.Version FALLBACK_USER_KEY_PAIR_VERSION = UserKeyPair.Version.RSA4096;

    public ServerSettingsService(ServiceLocator locator, ServiceDependencies dependencies) {
        super(locator, dependencies);
    }

    @ClientMethodImpl
    public ServerGeneralSettings getGeneralSettings() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerGeneralSettings> call = this.mApi.getServerGeneralSettings();
        Response<ApiServerGeneralSettings> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of server general settings failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiServerGeneralSettings data = (ApiServerGeneralSettings)response.body();
        return ServerMapper.fromApiGeneralSettings(data);
    }

    @ClientMethodImpl
    public ServerDefaults getDefaults() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerDefaults> call = this.mApi.getServerDefaults();
        Response<ApiServerDefaults> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of server defaults failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        ApiServerDefaults data = (ApiServerDefaults)response.body();
        return ServerMapper.fromApiServerDefaults(data);
    }

    @ClientMethodImpl
    public List<UserKeyPairAlgorithm> getAvailableUserKeyPairAlgorithms() throws DracoonNetIOException, DracoonApiException {
        List<ApiUserKeyPairAlgorithm> apiUserKeyPairAlgorithms = this.getUserKeyPairAlgorithms();
        ArrayList<UserKeyPairAlgorithm> algorithms = new ArrayList<UserKeyPairAlgorithm>();
        for (ApiUserKeyPairAlgorithm apiUserKeyPairAlgorithm : apiUserKeyPairAlgorithms) {
            UserKeyPairAlgorithm.Version version = UserKeyPairAlgorithm.Version.getByValue(apiUserKeyPairAlgorithm.version);
            UserKeyPairAlgorithm.State state = UserKeyPairAlgorithm.State.getByValue(apiUserKeyPairAlgorithm.status);
            if (version == null || state == null) continue;
            UserKeyPairAlgorithm algorithm = new UserKeyPairAlgorithm();
            algorithm.setVersion(version);
            algorithm.setState(state);
            algorithms.add(algorithm);
        }
        return algorithms;
    }

    public List<UserKeyPair.Version> getAvailableUserKeyPairVersions() throws DracoonNetIOException, DracoonApiException {
        List<ApiUserKeyPairAlgorithm> apiUserKeyPairAlgorithms = this.getUserKeyPairAlgorithms();
        ArrayList<UserKeyPair.Version> versions = new ArrayList<UserKeyPair.Version>();
        for (ApiUserKeyPairAlgorithm apiUserKeyPairAlgorithm : apiUserKeyPairAlgorithms) {
            try {
                versions.add(UserKeyPair.Version.getByValue((String)apiUserKeyPairAlgorithm.version));
            }
            catch (UnknownVersionException unknownVersionException) {}
        }
        return versions;
    }

    public UserKeyPair.Version getPreferredUserKeyPairVersion() throws DracoonNetIOException, DracoonApiException {
        List<UserKeyPair.Version> versions = this.getAvailableUserKeyPairVersions();
        return !versions.isEmpty() ? versions.get(0) : FALLBACK_USER_KEY_PAIR_VERSION;
    }

    private List<ApiUserKeyPairAlgorithm> getUserKeyPairAlgorithms() throws DracoonNetIOException, DracoonApiException {
        ApiServerCryptoAlgorithms apiCryptoAlgorithms = this.getCryptoAlgorithms();
        if (apiCryptoAlgorithms == null || apiCryptoAlgorithms.keyPairAlgorithms == null) {
            return Collections.emptyList();
        }
        List<ApiUserKeyPairAlgorithm> apiUserKeyPairAlgorithms = apiCryptoAlgorithms.keyPairAlgorithms;
        ServerSettingsService.sortUserKeyPairAlgorithms(apiUserKeyPairAlgorithms);
        return apiUserKeyPairAlgorithms;
    }

    private static void sortUserKeyPairAlgorithms(List<ApiUserKeyPairAlgorithm> userKeyPairAlgorithms) {
        String statusRequired = UserKeyPairAlgorithm.State.REQUIRED.getValue();
        userKeyPairAlgorithms.sort((alg1, alg2) -> {
            boolean isStatus2Required;
            boolean isStatus1Required = alg1.status != null && alg1.status.equals(statusRequired);
            boolean bl = isStatus2Required = alg2.status != null && alg2.status.equals(statusRequired);
            if (isStatus1Required && !isStatus2Required) {
                return -1;
            }
            if (!isStatus1Required && isStatus2Required) {
                return 1;
            }
            return 0;
        });
    }

    private ApiServerCryptoAlgorithms getCryptoAlgorithms() throws DracoonNetIOException, DracoonApiException {
        Call<ApiServerCryptoAlgorithms> call = this.mApi.getServerCryptoAlgorithms();
        Response<ApiServerCryptoAlgorithms> response = this.mHttpHelper.executeRequest(call);
        if (!response.isSuccessful()) {
            DracoonApiCode errorCode = this.mErrorParser.parseStandardError(response);
            String errorText = String.format("Query of server crypto algorithms failed with '%s'!", errorCode.name());
            this.mLog.d(LOG_TAG, errorText);
            throw new DracoonApiException(errorCode);
        }
        return (ApiServerCryptoAlgorithms)response.body();
    }
}

