/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.DracoonHttpConfig;
import com.dracoon.sdk.Log;
import com.dracoon.sdk.internal.api.DracoonApi;
import com.dracoon.sdk.internal.api.DracoonErrorParser;
import com.dracoon.sdk.internal.crypto.CryptoWrapper;
import com.dracoon.sdk.internal.crypto.EncryptionPasswordHolder;
import com.dracoon.sdk.internal.http.HttpHelper;
import com.dracoon.sdk.internal.service.FileStreamHelper;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ThreadHelper;
import java.net.URL;
import okhttp3.OkHttpClient;

public final class ServiceDependenciesImpl
implements ServiceDependencies {
    private Log mLog;
    private DracoonHttpConfig mHttpConfig;
    private OkHttpClient mHttpClient;
    private HttpHelper mHttpHelper;
    private URL mServerUrl;
    private DracoonApi mApi;
    private DracoonErrorParser mErrorParser;
    private EncryptionPasswordHolder mEncPasswordHolder;
    private CryptoWrapper mCryptoWrapper;
    private ThreadHelper mThreadHelper = new ThreadHelper();
    private FileStreamHelper mFileStreamHelper = new FileStreamHelper();

    private ServiceDependenciesImpl() {
    }

    @Override
    public Log getLog() {
        return this.mLog;
    }

    @Override
    public DracoonHttpConfig getHttpConfig() {
        return this.mHttpConfig;
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.mHttpClient;
    }

    @Override
    public HttpHelper getHttpHelper() {
        return this.mHttpHelper;
    }

    @Override
    public URL getServerUrl() {
        return this.mServerUrl;
    }

    @Override
    public DracoonApi getDracoonApi() {
        return this.mApi;
    }

    @Override
    public DracoonErrorParser getDracoonErrorParser() {
        return this.mErrorParser;
    }

    @Override
    public EncryptionPasswordHolder getEncryptionPasswordHolder() {
        return this.mEncPasswordHolder;
    }

    @Override
    public CryptoWrapper getCryptoWrapper() {
        return this.mCryptoWrapper;
    }

    @Override
    public ThreadHelper getThreadHelper() {
        return this.mThreadHelper;
    }

    @Override
    public FileStreamHelper getFileStreamHelper() {
        return this.mFileStreamHelper;
    }

    public static class Builder {
        private final ServiceDependenciesImpl mDependencies = new ServiceDependenciesImpl();

        public Builder setLog(Log log) {
            this.mDependencies.mLog = log;
            return this;
        }

        public Builder setHttpConfig(DracoonHttpConfig httpConfig) {
            this.mDependencies.mHttpConfig = httpConfig;
            return this;
        }

        public Builder setHttpClient(OkHttpClient httpClient) {
            this.mDependencies.mHttpClient = httpClient;
            return this;
        }

        public Builder setHttpHelper(HttpHelper httpHelper) {
            this.mDependencies.mHttpHelper = httpHelper;
            return this;
        }

        public Builder setServerUrl(URL serverUrl) {
            this.mDependencies.mServerUrl = serverUrl;
            return this;
        }

        public Builder setDracoonApi(DracoonApi api) {
            this.mDependencies.mApi = api;
            return this;
        }

        public Builder setDracoonErrorParser(DracoonErrorParser errorParser) {
            this.mDependencies.mErrorParser = errorParser;
            return this;
        }

        public Builder setEncryptionPasswordHolder(EncryptionPasswordHolder encPasswordHolder) {
            this.mDependencies.mEncPasswordHolder = encPasswordHolder;
            return this;
        }

        public Builder setCryptoWrapper(CryptoWrapper cryptoWrapper) {
            this.mDependencies.mCryptoWrapper = cryptoWrapper;
            return this;
        }

        public Builder setThreadHelper(ThreadHelper threadHelper) {
            this.mDependencies.mThreadHelper = threadHelper;
            return this;
        }

        public Builder setFileStreamHelper(FileStreamHelper fileStreamHelper) {
            this.mDependencies.mFileStreamHelper = fileStreamHelper;
            return this;
        }

        public ServiceDependenciesImpl build() {
            if (this.mDependencies.mLog == null || this.mDependencies.mHttpConfig == null || this.mDependencies.mHttpClient == null || this.mDependencies.mHttpHelper == null || this.mDependencies.mServerUrl == null || this.mDependencies.mApi == null || this.mDependencies.mErrorParser == null || this.mDependencies.mEncPasswordHolder == null || this.mDependencies.mCryptoWrapper == null || this.mDependencies.mThreadHelper == null || this.mDependencies.mFileStreamHelper == null) {
                throw new IllegalStateException("Service dependencies cannot be built. One or more dependencies were not set.");
            }
            return this.mDependencies;
        }
    }
}

