/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.DracoonHttpConfig;
import com.dracoon.sdk.internal.service.AccountService;
import com.dracoon.sdk.internal.service.AvatarDownloader;
import com.dracoon.sdk.internal.service.DownloadStream;
import com.dracoon.sdk.internal.service.DownloadThread;
import com.dracoon.sdk.internal.service.FileKeyFetcher;
import com.dracoon.sdk.internal.service.FileKeyGenerator;
import com.dracoon.sdk.internal.service.NodesService;
import com.dracoon.sdk.internal.service.ServerInfoService;
import com.dracoon.sdk.internal.service.ServerPoliciesService;
import com.dracoon.sdk.internal.service.ServerSettingsService;
import com.dracoon.sdk.internal.service.Service;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.internal.service.SharesService;
import com.dracoon.sdk.internal.service.UploadStream;
import com.dracoon.sdk.internal.service.UploadThread;
import com.dracoon.sdk.internal.service.UsersService;
import java.util.List;

public class ServiceLocatorImpl
implements ServiceLocator {
    private final ServerInfoService mServerInfoService;
    private final ServerSettingsService mServerSettingsService;
    private final ServerPoliciesService mServerPoliciesService;
    private final AccountService mAccountService;
    private final UsersService mUsersService;
    private final NodesService mNodesService;
    private final SharesService mSharesService;
    private final FileKeyFetcher mFileKeyFetcher;
    private final FileKeyGenerator mFileKeyGenerator;
    private final AvatarDownloader mAvatarDownloader;
    private final DownloadStream.Factory mDownloadStreamFactory;
    private final DownloadThread.Factory mDownloadThreadFactory;
    private final UploadStream.Factory mUploadStreamFactory;
    private final UploadThread.Factory mUploadThreadFactory;

    public ServiceLocatorImpl(ServiceDependencies dependencies) {
        this.mServerInfoService = new ServerInfoService(this, dependencies);
        this.mServerSettingsService = new ServerSettingsService(this, dependencies);
        this.mServerPoliciesService = new ServerPoliciesService(this, dependencies);
        this.mAccountService = new AccountService(this, dependencies);
        this.mUsersService = new UsersService(this, dependencies);
        this.mNodesService = new NodesService(this, dependencies);
        this.mSharesService = new SharesService(this, dependencies);
        this.mFileKeyFetcher = new FileKeyFetcher(this, dependencies);
        this.mFileKeyGenerator = new FileKeyGenerator(this, dependencies);
        this.mAvatarDownloader = new AvatarDownloader(dependencies.getLog(), dependencies.getHttpClient(), dependencies.getHttpHelper(), dependencies.getDracoonErrorParser());
        DracoonHttpConfig httpConfig = dependencies.getHttpConfig();
        long chunkSize = (long)httpConfig.getChunkSize() * 1024L;
        this.mDownloadStreamFactory = new DownloadStream.Factory(dependencies.getLog(), dependencies.getDracoonApi(), dependencies.getHttpClient(), dependencies.getHttpHelper(), dependencies.getDracoonErrorParser(), dependencies.getCryptoWrapper(), chunkSize);
        this.mDownloadThreadFactory = new DownloadThread.Factory(dependencies.getLog(), this.mDownloadStreamFactory);
        this.mUploadStreamFactory = new UploadStream.Factory(dependencies.getLog(), dependencies.getDracoonApi(), dependencies.getHttpClient(), dependencies.getHttpHelper(), dependencies.getDracoonErrorParser(), dependencies.getCryptoWrapper(), chunkSize);
        this.mUploadThreadFactory = new UploadThread.Factory(dependencies.getLog(), this.mUploadStreamFactory);
    }

    @Override
    public ServerInfoService getServerInfoService() {
        return this.mServerInfoService;
    }

    @Override
    public ServerSettingsService getServerSettingsService() {
        return this.mServerSettingsService;
    }

    @Override
    public ServerPoliciesService getServerPoliciesService() {
        return this.mServerPoliciesService;
    }

    @Override
    public AccountService getAccountService() {
        return this.mAccountService;
    }

    @Override
    public UsersService getUsersService() {
        return this.mUsersService;
    }

    @Override
    public NodesService getNodesService() {
        return this.mNodesService;
    }

    @Override
    public SharesService getSharesService() {
        return this.mSharesService;
    }

    @Override
    public FileKeyFetcher getFileKeyFetcher() {
        return this.mFileKeyFetcher;
    }

    @Override
    public FileKeyGenerator getFileKeyGenerator() {
        return this.mFileKeyGenerator;
    }

    @Override
    public AvatarDownloader getAvatarDownloader() {
        return this.mAvatarDownloader;
    }

    @Override
    public DownloadStream.Factory getDownloadStreamFactory() {
        return this.mDownloadStreamFactory;
    }

    @Override
    public DownloadThread.Factory getDownloadThreadFactory() {
        return this.mDownloadThreadFactory;
    }

    @Override
    public UploadStream.Factory getUploadStreamFactory() {
        return this.mUploadStreamFactory;
    }

    @Override
    public UploadThread.Factory getUploadThreadFactory() {
        return this.mUploadThreadFactory;
    }

    @Override
    public List<Service> getServices() {
        return List.of(this.mServerInfoService, this.mServerSettingsService, this.mServerPoliciesService, this.mAccountService, this.mUsersService, this.mNodesService, this.mSharesService);
    }
}

