/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.Log;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonCryptoException;
import com.dracoon.sdk.error.DracoonException;
import com.dracoon.sdk.error.DracoonFileIOException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.service.UploadStream;
import com.dracoon.sdk.model.FileUploadCallback;
import com.dracoon.sdk.model.FileUploadRequest;
import com.dracoon.sdk.model.Node;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class UploadThread
extends Thread {
    private static final String LOG_TAG = UploadThread.class.getSimpleName();
    private static final int BLOCK_SIZE = 2048;
    private final Log mLog;
    private final String mId;
    private final UploadStream mUploadStream;
    private final InputStream mInputStream;
    private Thread mThread;
    private final List<FileUploadCallback> mCallbacks = new ArrayList<FileUploadCallback>();

    private UploadThread(Log log, UploadStream.Factory factory, String id, FileUploadRequest request, long length, UserPublicKey userPublicKey, PlainFileKey fileKey, InputStream inputStream) {
        this.mLog = log;
        this.mId = id;
        this.mUploadStream = factory.create(id, request, length, userPublicKey, fileKey);
        this.mInputStream = inputStream;
    }

    public void addCallback(FileUploadCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
            this.mUploadStream.addCallback(callback);
        }
    }

    public void removeCallback(FileUploadCallback callback) {
        if (callback != null) {
            this.mCallbacks.remove(callback);
            this.mUploadStream.removeCallback(callback);
        }
    }

    @Override
    public void run() {
        this.mThread = this;
        try {
            this.upload();
        }
        catch (DracoonException dracoonException) {
            // empty catch block
        }
    }

    public Node runSync() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        this.mThread = Thread.currentThread();
        return this.upload();
    }

    private Node upload() throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        Node node = null;
        try {
            int bytesRead;
            this.mUploadStream.start();
            byte[] buffer = new byte[2048];
            while ((bytesRead = this.mInputStream.read(buffer)) != -1) {
                this.mUploadStream.write(buffer, 0, bytesRead);
            }
            node = this.mUploadStream.complete();
        }
        catch (IOException e) {
            if (this.mThread.isInterrupted()) {
                this.notifyCanceled(this.mId);
                return null;
            }
            Throwable cause = e.getCause();
            if (cause instanceof DracoonException) {
                this.rethrow((DracoonException)cause);
            }
            String errorText = "File read failed!";
            this.mLog.d(LOG_TAG, errorText);
            DracoonFileIOException ex = new DracoonFileIOException(errorText, e);
            this.notifyFailed(this.mId, ex);
            throw ex;
        }
        return node;
    }

    private void rethrow(DracoonException e) throws DracoonNetIOException, DracoonApiException, DracoonCryptoException, DracoonFileIOException {
        if (e instanceof DracoonNetIOException) {
            throw (DracoonNetIOException)e;
        }
        if (e instanceof DracoonApiException) {
            throw (DracoonApiException)e;
        }
        if (e instanceof DracoonCryptoException) {
            throw (DracoonCryptoException)e;
        }
        if (e instanceof DracoonFileIOException) {
            throw (DracoonFileIOException)e;
        }
    }

    private void notifyCanceled(String id) {
        for (FileUploadCallback callback : this.mCallbacks) {
            callback.onCanceled(id);
        }
    }

    private void notifyFailed(String id, DracoonException e) {
        for (FileUploadCallback callback : this.mCallbacks) {
            callback.onFailed(id, e);
        }
    }

    public static class Factory {
        private final Log mLog;
        private final UploadStream.Factory mUploadStreamFactory;

        public Factory(Log log, UploadStream.Factory uploadStreamFactory) {
            this.mLog = log;
            this.mUploadStreamFactory = uploadStreamFactory;
        }

        public UploadThread create(String id, FileUploadRequest request, long length, UserPublicKey userPublicKey, PlainFileKey fileKey, InputStream inputStream) {
            return new UploadThread(this.mLog, this.mUploadStreamFactory, id, request, length, userPublicKey, fileKey, inputStream);
        }
    }
}

