/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.service;

import com.dracoon.sdk.DracoonClient;
import com.dracoon.sdk.error.DracoonApiException;
import com.dracoon.sdk.error.DracoonNetIOException;
import com.dracoon.sdk.internal.ClientImpl;
import com.dracoon.sdk.internal.ClientMethodImpl;
import com.dracoon.sdk.internal.service.BaseService;
import com.dracoon.sdk.internal.service.ServiceDependencies;
import com.dracoon.sdk.internal.service.ServiceLocator;
import com.dracoon.sdk.internal.validator.UserValidator;
import java.util.UUID;

@ClientImpl(value=DracoonClient.Users.class)
public class UsersService
extends BaseService {
    public UsersService(ServiceLocator locator, ServiceDependencies dependencies) {
        super(locator, dependencies);
    }

    @ClientMethodImpl
    public byte[] getUserAvatar(long userId, UUID avatarUuid) throws DracoonNetIOException, DracoonApiException {
        UserValidator.validateUserId(userId);
        UserValidator.validateAvatarUuid(avatarUuid);
        String downloadUrl = this.buildApiUrl("downloads", "avatar", Long.toString(userId), avatarUuid.toString());
        return this.mServiceLocator.getAvatarDownloader().downloadAvatar(downloadUrl);
    }
}

