/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    private DateUtils() {
    }

    public static Date parseDate(String value) {
        if (value == null) {
            return null;
        }
        DateFormat df = DateUtils.createDateFormat("yyyy-MM-dd");
        try {
            return df.parse(value);
        }
        catch (ParseException e) {
            throw new Error(e);
        }
    }

    public static String formatDate(Date value) {
        if (value == null) {
            return null;
        }
        DateFormat df = DateUtils.createDateFormat("yyyy-MM-dd");
        return df.format(value);
    }

    public static Date parseTime(String value) {
        if (value == null) {
            return null;
        }
        DateFormat tf = DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            return tf.parse(value);
        }
        catch (ParseException e) {
            throw new Error(e);
        }
    }

    public static String formatTime(Date value) {
        if (value == null) {
            return null;
        }
        DateFormat tf = DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return tf.format(value);
    }

    private static DateFormat createDateFormat(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }
}

