/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.validator;

import com.dracoon.sdk.internal.validator.BaseValidator;
import com.dracoon.sdk.internal.validator.ValidatorUtils;
import com.dracoon.sdk.model.FileUploadRequest;
import com.dracoon.sdk.model.UpdateFileRequest;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class FileValidator
extends BaseValidator {
    private FileValidator() {
    }

    public static void validateUploadRequest(String id, FileUploadRequest request, File file) {
        ValidatorUtils.validateString("Upload ID", id, false);
        FileValidator.validateUploadRequest(request);
        ValidatorUtils.validateNotNull("Upload file", file);
    }

    public static void validateUploadRequest(String id, FileUploadRequest request, InputStream is) {
        ValidatorUtils.validateString("Upload ID", id, false);
        FileValidator.validateUploadRequest(request);
        ValidatorUtils.validateNotNull("Upload stream", is);
    }

    public static void validateUploadRequest(FileUploadRequest request) {
        ValidatorUtils.validateNotNull("Upload request", request);
        FileValidator.validateParentNodeId(request.getParentId());
        FileValidator.validateFileName(request.getName());
    }

    public static void validateDownloadRequest(String id, File file) {
        FileValidator.validateDownloadRequest(id);
        ValidatorUtils.validateNotNull("Download file", file);
    }

    public static void validateDownloadRequest(String id, OutputStream os) {
        FileValidator.validateDownloadRequest(id);
        ValidatorUtils.validateNotNull("Download stream", os);
    }

    private static void validateDownloadRequest(String id) {
        ValidatorUtils.validateString("Download ID", id, false);
    }

    public static void validateUpdateRequest(UpdateFileRequest request) {
        ValidatorUtils.validateNotNull("File update request", request);
        FileValidator.validateFileId(request.getId());
        if (request.getName() != null) {
            FileValidator.validateFileName(request.getName());
        }
    }
}

