/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.internal.validator;

import com.dracoon.sdk.internal.validator.BaseValidator;
import com.dracoon.sdk.internal.validator.ValidatorUtils;
import com.dracoon.sdk.model.CreateRoomRequest;
import com.dracoon.sdk.model.UpdateRoomConfigRequest;
import com.dracoon.sdk.model.UpdateRoomRequest;

public class RoomValidator
extends BaseValidator {
    private RoomValidator() {
    }

    public static void validateCreateRequest(CreateRoomRequest request) {
        ValidatorUtils.validateNotNull("Room creation request", request);
        if (request.getParentId() != null) {
            RoomValidator.validateParentNodeId(request.getParentId());
        }
        RoomValidator.validateRoomName(request.getName());
        RoomValidator.validateQuota(request.getQuota());
        RoomValidator.validatePeriod(request.getRecycleBinRetentionPeriod());
        if ((request.getAdminUserIds() == null || request.getAdminUserIds().isEmpty()) && (request.getAdminGroupIds() == null || request.getAdminGroupIds().isEmpty())) {
            throw new IllegalArgumentException("Room must have an admin user or admin group.");
        }
        if (request.getAdminUserIds() != null) {
            RoomValidator.validateUserIds(request.getAdminUserIds());
        }
        if (request.getAdminGroupIds() != null) {
            RoomValidator.validateGroupIds(request.getAdminGroupIds());
        }
    }

    public static void validateUpdateRequest(UpdateRoomRequest request) {
        ValidatorUtils.validateNotNull("Room update request", request);
        if (request.getName() != null) {
            RoomValidator.validateRoomName(request.getName());
        }
        RoomValidator.validateRoomId(request.getId());
        RoomValidator.validateQuota(request.getQuota());
    }

    public static void validateUpdateConfigRequest(UpdateRoomConfigRequest request) {
        ValidatorUtils.validateNotNull("Room config update request", request);
        RoomValidator.validateRoomId(request.getId());
        RoomValidator.validatePeriod(request.getRecycleBinRetentionPeriod());
        if (request.getAdminUserIds() != null) {
            RoomValidator.validateUserIds(request.getAdminUserIds());
        }
        if (request.getAdminGroupIds() != null) {
            RoomValidator.validateGroupIds(request.getAdminGroupIds());
        }
    }
}

