/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.model;

import com.dracoon.sdk.model.Classification;
import com.dracoon.sdk.model.GroupMemberAcceptance;
import java.util.List;

public class CreateRoomRequest {
    private Long mParentId;
    private String mName;
    private Long mQuota;
    private String mNotes;
    private Boolean mHasRecycleBin;
    private Integer mRecycleBinRetentionPeriod;
    private Boolean mHasInheritPermissions;
    private List<Long> mAdminUserIds;
    private List<Long> mAdminGroupIds;
    private GroupMemberAcceptance mNewGroupMemberAcceptance;
    private Classification mClassification;

    private CreateRoomRequest() {
    }

    public Long getParentId() {
        return this.mParentId;
    }

    public String getName() {
        return this.mName;
    }

    public Long getQuota() {
        return this.mQuota;
    }

    public String getNotes() {
        return this.mNotes;
    }

    public Boolean hasRecycleBin() {
        return this.mHasRecycleBin;
    }

    public Integer getRecycleBinRetentionPeriod() {
        return this.mRecycleBinRetentionPeriod;
    }

    public Boolean hasInheritPermissions() {
        return this.mHasInheritPermissions;
    }

    public List<Long> getAdminUserIds() {
        return this.mAdminUserIds;
    }

    public List<Long> getAdminGroupIds() {
        return this.mAdminGroupIds;
    }

    public GroupMemberAcceptance getNewGroupMemberAcceptance() {
        return this.mNewGroupMemberAcceptance;
    }

    public Classification getClassification() {
        return this.mClassification;
    }

    public static class Builder {
        private final CreateRoomRequest mRequest = new CreateRoomRequest();

        public Builder(String name) {
            this.mRequest.mName = name;
        }

        public Builder parentId(Long parentId) {
            this.mRequest.mParentId = parentId;
            return this;
        }

        public Builder quota(Long quota) {
            this.mRequest.mQuota = quota;
            return this;
        }

        public Builder notes(String notes) {
            this.mRequest.mNotes = notes;
            return this;
        }

        public Builder hasRecycleBin(Boolean hasRecycleBin) {
            this.mRequest.mHasRecycleBin = hasRecycleBin;
            return this;
        }

        public Builder recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
            this.mRequest.mRecycleBinRetentionPeriod = recycleBinRetentionPeriod;
            return this;
        }

        public Builder hasInheritPermissions(Boolean hasInheritPermissions) {
            this.mRequest.mHasInheritPermissions = hasInheritPermissions;
            return this;
        }

        public Builder adminUserIds(List<Long> adminUserIds) {
            this.mRequest.mAdminUserIds = adminUserIds;
            return this;
        }

        public Builder adminGroupIds(List<Long> adminGroupIds) {
            this.mRequest.mAdminGroupIds = adminGroupIds;
            return this;
        }

        public Builder newGroupMemberAcceptance(GroupMemberAcceptance newGroupMemberAcceptance) {
            this.mRequest.mNewGroupMemberAcceptance = newGroupMemberAcceptance;
            return this;
        }

        public Builder classification(Classification classification) {
            this.mRequest.mClassification = classification;
            return this;
        }

        public CreateRoomRequest build() {
            return this.mRequest;
        }
    }
}

