/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.model;

import com.dracoon.sdk.model.Classification;
import com.dracoon.sdk.model.GroupMemberAcceptance;
import java.util.List;

public class UpdateRoomConfigRequest {
    private Long mId;
    private Integer mRecycleBinRetentionPeriod;
    private Boolean mHasInheritPermissions;
    private List<Long> mAdminUserIds;
    private List<Long> mAdminGroupIds;
    private GroupMemberAcceptance mNewGroupMemberAcceptance;
    private Classification mClassification;

    private UpdateRoomConfigRequest() {
    }

    public Long getId() {
        return this.mId;
    }

    public Integer getRecycleBinRetentionPeriod() {
        return this.mRecycleBinRetentionPeriod;
    }

    public Boolean hasInheritPermissions() {
        return this.mHasInheritPermissions;
    }

    public List<Long> getAdminUserIds() {
        return this.mAdminUserIds;
    }

    public List<Long> getAdminGroupIds() {
        return this.mAdminGroupIds;
    }

    public GroupMemberAcceptance getNewGroupMemberAcceptance() {
        return this.mNewGroupMemberAcceptance;
    }

    public Classification getClassification() {
        return this.mClassification;
    }

    public static class Builder {
        private final UpdateRoomConfigRequest mRequest = new UpdateRoomConfigRequest();

        public Builder(Long id) {
            this.mRequest.mId = id;
        }

        public Builder recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
            this.mRequest.mRecycleBinRetentionPeriod = recycleBinRetentionPeriod;
            return this;
        }

        public Builder hasInheritPermissions(Boolean hasInheritPermissions) {
            this.mRequest.mHasInheritPermissions = hasInheritPermissions;
            return this;
        }

        public Builder adminUserIds(List<Long> adminUserIds) {
            this.mRequest.mAdminUserIds = adminUserIds;
            return this;
        }

        public Builder adminGroupIds(List<Long> adminGroupIds) {
            this.mRequest.mAdminGroupIds = adminGroupIds;
            return this;
        }

        public Builder newGroupMemberAcceptance(GroupMemberAcceptance newGroupMemberAcceptance) {
            this.mRequest.mNewGroupMemberAcceptance = newGroupMemberAcceptance;
            return this;
        }

        public Builder classification(Classification classification) {
            this.mRequest.mClassification = classification;
            return this;
        }

        public UpdateRoomConfigRequest build() {
            return this.mRequest;
        }
    }
}

