/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.canvas;

import com.dragome.guia.GuiaServiceLocator;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.canvas.interfaces.ConcatCanvas;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLCanvas
implements Canvas<Element> {
    protected Element content;

    public HTMLCanvas(Element content) {
        this.content = content;
    }

    public HTMLCanvas() {
    }

    public Element getContent() {
        return this.content;
    }

    public void setContent(Element object) {
        this.content = object;
    }

    public void replaceSection(String anAlias, Canvas<?> aCanvas) {
        List<Element> foundElement = this.getElementsByClassName("replaced: " + anAlias, this.getContent());
        Element elementToReplace = foundElement.get(0);
        Element parentNode = (Element)elementToReplace.getParentNode();
        HTMLCanvas.replaceElementByCanvas(aCanvas, elementToReplace, parentNode, false);
    }

    public static void replaceElementByCanvas(Canvas<?> aCanvas, Element elementToReplace, Element parentNode, boolean removeReplacements) {
        Node grandParentNode = parentNode.getParentNode();
        Node cloneNode = parentNode.cloneNode(false);
        if (grandParentNode != null) {
            grandParentNode.replaceChild(cloneNode, parentNode);
        }
        if (aCanvas instanceof ConcatCanvas) {
            Object element;
            ConcatCanvas concatCanvas = (ConcatCanvas)aCanvas;
            List content2 = (List)concatCanvas.getContent();
            if (content2.size() > 0 && (element = content2.get(content2.size() - 1)) instanceof Element) {
                Element replacement = (Element)((Element)element).cloneNode(true);
                replacement.removeAttribute("data-template");
                parentNode.replaceChild(replacement, elementToReplace);
                elementToReplace = replacement;
                for (int i = content2.size() - 2; i >= 0; --i) {
                    replacement = (Element)((Element)content2.get(i)).cloneNode(true);
                    replacement.removeAttribute("data-template");
                    parentNode.insertBefore(replacement, elementToReplace);
                    elementToReplace = replacement;
                }
            }
        } else {
            Element replacement = (Element)((Node)aCanvas.getContent()).cloneNode(true);
            replacement.removeAttribute("data-template");
            parentNode.replaceChild(replacement, elementToReplace);
        }
        if (removeReplacements) {
            GuiaServiceLocator.getInstance().getTemplateManager().getCanvasFactory().getCanvasHelper().removeReplacedElements(parentNode);
        }
        if (grandParentNode != null) {
            grandParentNode.replaceChild(parentNode, cloneNode);
        }
    }

    public List<Element> getElementsByClassName(String classname, Element node) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = node.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element item = (Element)nodeList.item(i);
            String classAttribute = item.getAttribute("data-template");
            if (classAttribute == null || !classAttribute.contains(classname)) continue;
            result.add(item);
        }
        return result;
    }
}

