/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html;

import com.dragome.render.html.renderers.Mergeable;
import com.dragome.templates.TemplateImpl;
import com.dragome.templates.interfaces.Content;
import com.dragome.templates.interfaces.Template;
import com.dragome.templates.interfaces.TemplateListener;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HTMLTemplateChangedListener
implements TemplateListener {
    private boolean enabled = true;

    private boolean isInvokingEvents() {
        return this.enabled;
    }

    public void insertBefore(Template newChild, Template referenceChild, Map<String, Template> children, List<Template> childrenList, Template template) {
        if (this.isInvokingEvents()) {
            Element referenceElement = (Element)referenceChild.getContent().getValue();
            int index = childrenList.indexOf(referenceChild) - 1;
            if (index < 0) {
                index = 0;
            }
            childrenList.add(index, newChild);
            children.put(newChild.getName(), newChild);
            Element newElement = (Element)newChild.getContent().getValue();
            referenceElement.getParentNode().insertBefore(newElement, referenceElement);
            newChild.setParent(template);
        }
    }

    public void insertAfter(Template newChild, Template referenceChild, Map<String, Template> children, List<Template> childrenList, Template template) {
        if (this.isInvokingEvents()) {
            Element referenceElement = (Element)referenceChild.getContent().getValue();
            childrenList.add(childrenList.indexOf(referenceChild) + 1, newChild);
            children.put(newChild.getName(), newChild);
            Node nextSibling = referenceElement.getNextSibling();
            Element newElement = (Element)newChild.getContent().getValue();
            if (nextSibling != null) {
                referenceElement.getParentNode().insertBefore(newElement, nextSibling);
            } else {
                referenceElement.getParentNode().appendChild(newElement);
            }
            newChild.setParent(template);
        }
    }

    public void contentChanged(Content<?> oldTemplateContent, Content<?> newTemplateContent) {
        Element element;
        if (this.isInvokingEvents() && (element = (Element)(oldTemplateContent != null ? oldTemplateContent.getValue() : null)) != null) {
            if (newTemplateContent.getValue() instanceof Mergeable) {
                Mergeable mergeable = (Mergeable)newTemplateContent.getValue();
                mergeable.mergeWith(element);
            } else {
                Node parentNode = element.getParentNode();
                if (parentNode != null) {
                    String className = element.getAttribute("class");
                    Element newValue = (Element)newTemplateContent.getValue();
                    newValue.setAttribute("class", className);
                    parentNode.replaceChild(newValue, element);
                }
            }
        }
    }

    public void childRemoved(Template referenceChild) {
        Element referenceElement;
        if (this.isInvokingEvents() && (referenceElement = (Element)referenceChild.getContent().getValue()).getParentNode() != null) {
            referenceElement.getParentNode().removeChild(referenceElement);
        }
    }

    public void childAdded(Template parent, Template child) {
        if (this.isInvokingEvents()) {
            Element parentElement = (Element)parent.getContent().getValue();
            Element childElement = (Element)child.getContent().getValue();
            parentElement.appendChild(childElement);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void childReplaced(TemplateImpl parent, Template previousChild, Template newChild) {
        if (this.isInvokingEvents()) {
            Element previousElement = (Element)previousChild.getContent().getValue();
            Element newElement = (Element)newChild.getContent().getValue();
            previousElement.getParentNode().replaceChild(newElement, previousElement);
        }
    }
}

