/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html;

import com.dragome.render.DomHelper;
import com.dragome.render.interfaces.TemplateHandler;
import com.dragome.services.WebServiceLocator;
import com.dragome.templates.ContentImpl;
import com.dragome.templates.HTMLTemplateFactory;
import com.dragome.templates.interfaces.Content;
import com.dragome.templates.interfaces.Template;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class HTMLTemplateHandler
implements TemplateHandler {
    public void makeVisible(Template clonedChild) {
        Element element = (Element)clonedChild.getContent().getValue();
        DomHelper.removeClassName(element, "dragome-hide");
    }

    public void makeInvisible(Template clonedChild) {
        Element element = (Element)clonedChild.getContent().getValue();
        DomHelper.addClassName(element, "dragome-hide");
    }

    public Template clone(Template mainPanel) {
        return this.cloneTemplate(mainPanel);
    }

    private Template cloneTemplate(Template template) {
        Element node = (Element)template.getContent().getValue();
        Element cloneNode = (Element)node.cloneNode(true);
        cloneNode.setAttribute("data-template-cloning", "true");
        node.getParentNode().appendChild(cloneNode);
        String path = "[data-template-cloning=\"true\"]  ";
        Template clonedTemplate = this.cloneChildren(template, path, cloneNode);
        cloneNode.removeAttribute("data-template-cloning");
        node.getParentNode().removeChild(cloneNode);
        return clonedTemplate;
    }

    private Template cloneChildren(Template template, String aSelector, Element cloneNode) {
        cloneNode.removeAttribute("data-debug-id");
        Template clonedTemplate = HTMLTemplateFactory.createTemplate(template.getName());
        clonedTemplate.setFiringEvents(false);
        clonedTemplate.setContent((Content)new ContentImpl((Object)cloneNode));
        for (Template child : template.getChildrenMap().values()) {
            String childName = child.getName();
            String selector = aSelector + " " + this.createSelector(childName);
            Element clonedElement = WebServiceLocator.getInstance().getDomHandler().getElementBySelector(selector);
            Template clonedChild = this.cloneChildren(child, selector, clonedElement);
            clonedTemplate.addChild(clonedChild);
        }
        clonedTemplate.setFiringEvents(true);
        return clonedTemplate;
    }

    private String createSelector(String childName) {
        return "[data-template=\"replaced: " + childName + "\"]";
    }

    public void markWith(Template child, String name) {
        ((Element)child.getContent().getValue()).setAttribute("data-result", name);
    }

    public void releaseTemplate(Template clonedChild) {
        ((Element)clonedChild.getContent().getValue()).removeAttribute("data-template");
    }

    public List<Template> cloneTemplates(List<Template> templates) {
        ArrayList<Template> clonedTemplates = new ArrayList<Template>();
        for (Template childTemplate : templates) {
            clonedTemplates.add(this.clone(childTemplate));
        }
        return clonedTemplates;
    }
}

