/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html;

import com.dragome.guia.GuiaServiceLocator;
import com.dragome.render.html.HtmlTemplateHelper;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.services.WebServiceLocator;
import com.dragome.templates.interfaces.Template;
import com.dragome.templates.interfaces.TemplateLoadingStrategy;
import org.w3c.dom.Element;

public class HTMLTemplateLoadingStrategy
implements TemplateLoadingStrategy {
    protected String templateContent;
    private int templateNumber = 0;

    public Element getContainerElement() {
        return (Element)WebServiceLocator.getInstance().getDomHandler().getDocument().getElementsByTagName("body").item(0);
    }

    public void loadMainTemplate(String templateName) {
        this.templateContent = HtmlTemplateHelper.getHtmlPart(templateName + ".html", null);
    }

    public Template loadTemplateCloned(String templateName, String aContainerId) {
        Template template = this.loadTemplate(templateName, aContainerId);
        return GuiaServiceLocator.getInstance().getTemplateHandler().clone(template);
    }

    public Template loadTemplate(String templateName, String aContainerId) {
        String templateContent = HtmlTemplateHelper.getHtmlPart(templateName + ".html", aContainerId);
        return this.createTemplateFromHtml(templateContent);
    }

    public Template createTemplateFromHtml(String templateContent) {
        Element element = WebServiceLocator.getInstance().getDomHandler().getDocument().createElement("div");
        element.setAttribute("class", "dragome-hide");
        Element childElement = WebServiceLocator.getInstance().getDomHandler().getDocument().createElement("div");
        element.appendChild(childElement);
        this.getContainerElement().getParentNode().appendChild(element);
        AbstractHTMLComponentRenderer.setElementInnerHTML(childElement, templateContent);
        String aTemplateName = "loaded-template-" + this.templateNumber++;
        childElement.setAttribute("data-template", aTemplateName);
        childElement.setAttribute("id", aTemplateName);
        Template createTemplate = GuiaServiceLocator.getInstance().getTemplateManager().createTemplate(aTemplateName);
        return createTemplate;
    }

    public void hideContainer() {
        this.getContainerElement().setAttribute("style", "display:none;");
    }

    public void setupContainer() {
        AbstractHTMLComponentRenderer.setElementInnerHTML(this.getContainerElement(), this.templateContent);
    }

    public void showContainer() {
        this.getContainerElement().setAttribute("style", "display:block;");
    }

    public Template getMainTemplate() {
        this.getContainerElement().setAttribute("data-template", "body");
        this.getContainerElement().setAttribute("id", "body");
        return GuiaServiceLocator.getInstance().getTemplateManager().createTemplate("body");
    }

    public Template loadTemplate(String templateName) {
        return this.loadTemplate(templateName, "");
    }
}

