/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.commons.javascript.ScriptHelper;
import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.guia.events.listeners.interfaces.BlurListener;
import com.dragome.guia.events.listeners.interfaces.ClickListener;
import com.dragome.guia.events.listeners.interfaces.DoubleClickListener;
import com.dragome.guia.events.listeners.interfaces.InputListener;
import com.dragome.guia.events.listeners.interfaces.KeyDownListener;
import com.dragome.guia.events.listeners.interfaces.KeyPressListener;
import com.dragome.guia.events.listeners.interfaces.KeyUpListener;
import com.dragome.guia.events.listeners.interfaces.ListenerChanged;
import com.dragome.guia.events.listeners.interfaces.MouseOutListener;
import com.dragome.guia.events.listeners.interfaces.MouseOverListener;
import com.dragome.helpers.DragomeEntityManager;
import com.dragome.render.html.renderers.MultipleEventListener;
import com.dragome.render.interfaces.ComponentRenderer;
import com.dragome.web.enhancers.jsdelegate.JsCast;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.events.EventTarget;

public abstract class AbstractHTMLComponentRenderer<T>
implements ComponentRenderer<Element, T> {
    public static final String COMPONENT_ID_ATTRIBUTE = "data-component-id";
    private Set<String> listeners = new HashSet<String>();

    public static void setElementInnerHTML(Element label1, String aText) {
        ScriptHelper.put((String)"element", (Object)label1, null);
        ScriptHelper.put((String)"value", (Object)aText, null);
        ScriptHelper.evalNoResult((String)"element.node.innerHTML= value", null);
    }

    public static String getElementInnerHTML(Element label1) {
        ScriptHelper.put((String)"element", (Object)label1, null);
        return (String)ScriptHelper.eval((String)"element.node.innerHTML", null);
    }

    public void addListeners(final VisualComponent visualComponent, final Element element) {
        element.setAttribute(COMPONENT_ID_ATTRIBUTE, DragomeEntityManager.add((Object)visualComponent));
        visualComponent.addListener(ListenerChanged.class, (EventListener)new ListenerChanged(){

            public <T extends EventListener> void listenerAdded(Class<? extends T> type, T listener) {
                AbstractHTMLComponentRenderer.this.addListeners(visualComponent, element, type);
            }

            public <T extends EventListener> void listenerRemoved(Class<? extends T> type, T listener) {
            }
        });
        this.addListeners(visualComponent, element, null);
        visualComponent.getStyle().fireStyleChanged();
    }

    private void addListeners(VisualComponent visualComponent, Element element, Class<? extends EventListener> expectedType) {
        this.addListener(visualComponent, element, ClickListener.class, "click", expectedType);
        this.addListener(visualComponent, element, DoubleClickListener.class, "dblclick", expectedType);
        this.addListener(visualComponent, element, KeyUpListener.class, "keyup", expectedType);
        this.addListener(visualComponent, element, KeyDownListener.class, "keydown", expectedType);
        this.addListener(visualComponent, element, KeyPressListener.class, "keypress", expectedType);
        this.addListener(visualComponent, element, InputListener.class, "input", expectedType);
        this.addListener(visualComponent, element, MouseOverListener.class, "mouseover", expectedType);
        this.addListener(visualComponent, element, MouseOutListener.class, "mouseout", expectedType);
        this.addListener(visualComponent, element, BlurListener.class, "blur", expectedType);
        EventTarget eventTarget = (EventTarget)JsCast.castTo((Object)element, EventTarget.class);
        for (String listener : this.listeners) {
            eventTarget.addEventListener(listener, new MultipleEventListener(visualComponent), false);
        }
    }

    protected void addListener(VisualComponent visualComponent, Element element, Class<? extends EventListener> listenerType, String jsAttributeName, Class<? extends EventListener> expectedType) {
        if (visualComponent.hasListener(listenerType) && (expectedType == null || expectedType.equals(listenerType))) {
            this.listeners.add(jsAttributeName);
        }
    }
}

