/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.commons.javascript.ScriptHelper;
import com.dragome.guia.GuiaServiceLocator;
import com.dragome.guia.components.interfaces.VisualCheckbox;
import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.helpers.DragomeEntityManager;
import com.dragome.model.interfaces.ValueChangeEvent;
import com.dragome.model.interfaces.ValueChangeHandler;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.render.html.renderers.MergeableElement;
import org.w3c.dom.Element;

public class HTMLCheckboxRenderer
extends AbstractHTMLComponentRenderer<VisualCheckbox> {
    public Canvas<Element> render(final VisualCheckbox checkbox) {
        Canvas canvas = GuiaServiceLocator.getInstance().getTemplateManager().getCanvasFactory().createCanvas();
        canvas.setContent((Object)new MergeableElement(){

            @Override
            public void mergeWith(final Element button1) {
                String id = DragomeEntityManager.add((Object)checkbox);
                button1.setAttribute("type", "checkbox");
                button1.setAttribute("value", checkbox.getCaption());
                this.updateChecked(checkbox, button1);
                checkbox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        this.updateChecked(checkbox, button1);
                    }
                });
                HTMLCheckboxRenderer.this.addListeners((VisualComponent)checkbox, button1);
            }

            private void updateChecked(VisualCheckbox checkbox2, Element button1) {
                boolean checked = checkbox2.getValue() != null && (Boolean)checkbox2.getValue() != false;
                String isChecked = checked ? "true" : "false";
                ScriptHelper.put((String)"checked", (Object)isChecked, (Object)this);
                ScriptHelper.put((String)"button1", (Object)button1, (Object)this);
                ScriptHelper.evalNoResult((String)"button1.node.checked= (checked == 'true')", (Object)this);
            }
        });
        return canvas;
    }
}

