/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.render.html.renderers;

import com.dragome.guia.components.VisualButtonImpl;
import com.dragome.guia.components.VisualCheckboxImpl;
import com.dragome.guia.components.VisualLabelImpl;
import com.dragome.guia.components.VisualListBoxImpl;
import com.dragome.guia.components.VisualPanelImpl;
import com.dragome.guia.components.VisualRadioButton;
import com.dragome.guia.components.VisualTextFieldImpl;
import com.dragome.guia.components.interfaces.VisualComboBox;
import com.dragome.guia.components.interfaces.VisualComponent;
import com.dragome.guia.components.interfaces.VisualImage;
import com.dragome.guia.components.interfaces.VisualLabel;
import com.dragome.guia.components.interfaces.VisualLink;
import com.dragome.guia.components.interfaces.VisualProgressBar;
import com.dragome.guia.components.interfaces.VisualTextArea;
import com.dragome.render.canvas.interfaces.Canvas;
import com.dragome.render.html.renderers.AbstractHTMLComponentRenderer;
import com.dragome.render.html.renderers.HTMLButtonRenderer;
import com.dragome.render.html.renderers.HTMLCheckboxRenderer;
import com.dragome.render.html.renderers.HTMLComboBoxRenderer;
import com.dragome.render.html.renderers.HTMLImageRenderer;
import com.dragome.render.html.renderers.HTMLLabelRenderer;
import com.dragome.render.html.renderers.HTMLLinkRenderer;
import com.dragome.render.html.renderers.HTMLListRenderer;
import com.dragome.render.html.renderers.HTMLPanelRenderer;
import com.dragome.render.html.renderers.HTMLProgressBarRenderer;
import com.dragome.render.html.renderers.HTMLRadioButtonRenderer;
import com.dragome.render.html.renderers.HTMLTextAreaRenderer;
import com.dragome.render.html.renderers.HTMLTextFieldRenderer;
import com.dragome.render.interfaces.ComponentRenderer;
import com.dragome.services.ServiceLocator;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class HTMLComponentRenderer
implements ComponentRenderer<Element, VisualComponent> {
    private static Map<Class<? extends VisualComponent>, Class<? extends ComponentRenderer<Element, ? extends VisualComponent>>> renderers = new HashMap<Class<? extends VisualComponent>, Class<? extends ComponentRenderer<Element, ? extends VisualComponent>>>();

    public HTMLComponentRenderer() {
        HTMLComponentRenderer.addRenderFor(VisualImage.class, HTMLImageRenderer.class);
        HTMLComponentRenderer.addRenderFor(VisualLink.class, HTMLLinkRenderer.class);
    }

    public Canvas render(VisualComponent visualComponent) {
        AbstractHTMLComponentRenderer renderer = null;
        if (visualComponent instanceof VisualComboBox) {
            renderer = new HTMLComboBoxRenderer();
        } else if (visualComponent instanceof VisualListBoxImpl) {
            renderer = new HTMLListRenderer();
        } else if (visualComponent instanceof VisualPanelImpl) {
            renderer = new HTMLPanelRenderer();
        } else if (visualComponent instanceof VisualCheckboxImpl) {
            renderer = new HTMLCheckboxRenderer();
        } else if (visualComponent instanceof VisualButtonImpl) {
            renderer = new HTMLButtonRenderer();
        } else if (visualComponent instanceof VisualLabelImpl) {
            renderer = new HTMLLabelRenderer();
        } else if (visualComponent instanceof VisualTextFieldImpl) {
            renderer = new HTMLTextFieldRenderer();
        } else if (visualComponent instanceof VisualTextArea) {
            renderer = new HTMLTextAreaRenderer();
        } else if (visualComponent instanceof VisualRadioButton) {
            renderer = new HTMLRadioButtonRenderer();
        } else if (visualComponent instanceof VisualProgressBar) {
            renderer = new HTMLProgressBarRenderer();
        }
        for (Map.Entry<Class<? extends VisualComponent>, Class<? extends ComponentRenderer<Element, ? extends VisualComponent>>> entry : renderers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(visualComponent.getClass())) continue;
            renderer = (ComponentRenderer)ServiceLocator.getInstance().getReflectionService().createClassInstance(entry.getValue());
        }
        if (renderer != null) {
            return renderer.render(visualComponent);
        }
        return new HTMLLabelRenderer().render((VisualLabel<Object>)new VisualLabelImpl("l1", (Object)"no renderer!!"));
    }

    public static <A extends VisualComponent> void addRenderFor(Class<A> componentClass, Class<? extends ComponentRenderer<Element, ? extends A>> rendererClass) {
        renderers.put(componentClass, rendererClass);
    }
}

